<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .forgotbox {
            background: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
        }
        .forgotbox h3 {
            margin-bottom: 20px;
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        .form-control {
            border-radius: 4px;
            border: 1px solid #ced4da;
            box-shadow: none;
            height: 45px;
            padding: 10px 15px;
        }
        .btn-primary {
            background-color: #007bff;
            border: none;
            border-radius: 4px;
            height: 45px;
            font-size: 16px;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .logResult {
            margin-bottom: 20px;
        }
        .alert {
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="forgotbox">
        <div class="innerforgot" id="forgot-form">
            <form class="form-horizontal" id="forgotPasswordForm" enctype="multipart/form-data" action="" method="post">
                <h3>Forgot Password</h3>
                <div class="logResult"></div>

                <div class="form-group">
                    <div class="col-sm-12">
                        <input class="form-control" name="email" type="email" id="email" autocomplete="off" maxlength="100" placeholder="Enter your email address">
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-sm-12">
                        <button type="submit" class="btn btn-primary requestbtn">Send Reset Link</button>
                    </div>
                </div>
            </form>
        </div>

        <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('#forgotPasswordForm').submit(function (e) {
                    e.preventDefault();
                    var email = $('#email').val();

                    $.ajax({
                        type: "POST",
                        url: "forgot_password_handler.php",
                        data: { "email": email },
                        success: function (data) {
                            $('.logResult').html(data);
                            $('#forgotPasswordForm')[0].reset();
                        }
                    });
                });
            });
        </script>
    </div>
</body>
</html>
