<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
include '../west-liberty/swift/server/config.db.php'; // Ensure this file connects to your database

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $reset_token = bin2hex(random_bytes(16)); // Generate a random token

    // Initialize error variable
    $error = '';
    
    if (empty($email)) {
        $error = 'Please enter your email address.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Invalid email format.';
    }

    if ($error) {
        echo '<div class="alert alert-danger">' . $error . '</div>';
        exit();
    }

    try {
        // Check if email exists
        $stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            // Update the user's record with the reset token
            $stmt = $pdo->prepare('UPDATE users SET reset_token = ?, reset_expires = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE email = ?');
            $stmt->execute([$reset_token, $email]);

            // Send the reset email
            $mail = new PHPMailer(true);
            try {
                // Server settings
    $mail->isSMTP();
    $mail->Host = 'mail.west-libertygroup.com'; // Set the SMTP server to send through
    $mail->SMTPAuth = true;
    $mail->Username = 'no-reply@west-libertygroup.com'; // SMTP username
    $mail->Password = 'whodeybreathe'; // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Use SMTPS for port 465
$mail->Port = 465; // SSL port

                $mail->setFrom('no-reply@west-libertygroup.com', 'From Eliora - WEST - Liberty Online Support');
                $mail->addAddress($email);

                $mail->isHTML(true);
                $mail->Subject = 'Password Reset Request';
                
                $reset_link = "http://west-libertygroup.com/securepass/secure/authenticate/reset_password.php?token=" . $reset_token;

                $mail->Body = "
                    <html>
                    <head>
                        <style>
                            body {
                                font-family: Arial, sans-serif;
                                color: #333;
                                line-height: 1.6;
                            }
                            .container {
                                width: 100%;
                                max-width: 600px;
                                margin: 0 auto;
                                padding: 20px;
                                background: #f4f4f4;
                                border: 1px solid #ddd;
                                border-radius: 5px;
                            }
                            .header {
                                text-align: center;
                                padding-bottom: 20px;
                            }
                            .header img {
                                width: 150px;
                            }
                            .content {
                                padding: 20px;
                                background: #fff;
                                border-radius: 5px;
                                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                            }
                            .content h2 {
                                color: #0056b3;
                            }
                            .footer {
                                text-align: center;
                                padding-top: 20px;
                                font-size: 0.9em;
                                color: #777;
                            }
                            .footer a {
                                color: #0056b3;
                                text-decoration: none;
                            }
                        </style>
                    </head>
                    <body>
                        <div class='container'>
                            <div class='header'>
                                <img src='http://west-libertygroup.com/logo.png' alt='Swifftess Logo'>
                            </div>
                            <div class='content'>
                                <h2>Password Reset Request</h2>
                                <p>Hello,</p>
                                <p>We received a request to reset your password. Please click the link below to reset your password:</p>
                                <p><a href='$reset_link'>$reset_link</a></p>
                                <p>If you did not request this change, you can ignore this email.</p>
                            </div>
                            <div class='footer'>
                                <p>Thank you!</p>
                                <p>If you have any questions, please contact our support team.</p>
                                <p><a href='http://west-libertygroup.com'>Support</a></p>
                            </div>
                        </div>
                    </body>
                    </html>
                ";

                $mail->send();
                echo '<div class="alert alert-success">A password reset link has been sent to your email address.</div>';
            } catch (Exception $e) {
                echo '<div class="alert alert-danger">Failed to send reset email. Mailer Error: ' . $mail->ErrorInfo . '</div>';
            }
        } else {
            echo '<div class="alert alert-warning">No account found with that email address.</div>';
        }
    } catch (PDOException $e) {
        echo '<div class="alert alert-danger">Database error: ' . $e->getMessage() . '</div>';
    }
}
?>
