<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BLX Growth Online Services - Login</title>
    <link rel="shortcut icon" type="image/png" href="https://west-libertygroup.com/images/favicon.png">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/font-awesome.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/customcss.css" rel="stylesheet">
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
</head>
<body style="background-color: #f8f9fa; font-family: 'Roboto', sans-serif;">

<div class="container d-flex justify-content-center align-items-center vh-100">
    <div class="card shadow-lg p-4" style="width: 100%; max-width: 400px; border-radius: 10px;">
        <div class="card-body">
            <div class="text-center mb-4">
                <img src="https://west-libertygroup.com/images/favicon.png" alt="Logo" style="width: 100px;">
                <h5 class="mt-3">BLX Growth Online Services</h5>
            </div>
            <form id="pcLogForm">
                <div class="form-group">
                    <label for="id">Email Address</label>
                    <input type="email" id="id" name="id" class="form-control" placeholder="Enter your email" required>
                </div>
                <div class="form-group mt-3">
                    <label for="pass">Password</label>
                    <div class="input-group">
                        <input type="password" id="pass" name="pass" class="form-control" placeholder="Enter your password" required>
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-secondary" id="togglePassword">
                                <i class="fa fa-eye"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="logResult mt-2"></div>
                <button type="submit" class="btn btn-primary btn-block mt-4 loginbtn">Login</button>
            </form>
            <p class="text-center mt-3">
                <a href="forgot_password" style="text-decoration: none;">Forgot Password?</a>
            </p>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('.loginbtn').on('click', function() {
            var $this = $(this);
            var loadingText = '<i class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></i> Processing...';

            if ($(this).html() !== loadingText) {
                $this.data('original-text', $(this).html());
                $this.html(loadingText);
            }
            setTimeout(function() {
                $this.html($this.data('original-text'));
            }, 5000);
        });

        $('#pcLogForm').submit(function(e) {
            e.preventDefault();
            var id = $('#id').val();
            var pass = $('#pass').val();

            $.ajax({
                type: "POST",
                url: "loginp.php",
                data: { "id": id, "pass": pass },
                success: function(data) {
                    $('.logResult').html(data);
                }
            });
        });

        $('#togglePassword').click(function() {
            var passInput = $('#pass');
            var passType = passInput.attr('type') === 'password' ? 'text' : 'password';
            passInput.attr('type', passType);
            $(this).toggleClass('fa-eye fa-eye-slash');
        });
    });
</script>

</body>
</html>
