<?php
session_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require '../west-libery/swift/server/config.db.php'; // Ensure this file connects to your database

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $pass = $_POST['pass'];

    // Validate input
    if (empty($id) || empty($pass)) {
        echo '<div class="alert alert-danger">Please fill in all fields.</div>';
        exit();
    }

    try {
        // Prepare and execute the query
        $stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
        $stmt->execute([$id]);

        // Fetch user record
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user && password_verify($pass, $user['password'])) {
            if ($user['is_verified']) {
                // Save user info in session
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_name'] = $user['full_name']; // Assuming there's a 'full_name' field

                // Send login confirmation email
                $mail = new PHPMailer(true);
                try {
                    // Server settings
    $mail->isSMTP();
    $mail->Host = 'mail.west-libertygroup.com'; // Set the SMTP server to send through
    $mail->SMTPAuth = true;
    $mail->Username = 'no-reply@west-libertygroup.com'; // SMTP username
    $mail->Password = 'whodeybreathe'; // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Use SMTPS for port 465
$mail->Port = 465; // SSL port


                    $mail->setFrom('no-reply@west-libertygroup.com', 'west-liberty Online Support');
                    $mail->addAddress($_SESSION['user_email'], $_SESSION['user_name']);

                    $mail->isHTML(true);
                    $mail->Subject = 'Login Successful';
                    $mail->Body = "
                    <html>
                    <body style='font-family: Arial, sans-serif; color: #333; text-align: center;'>
                        <div style='max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 8px;'>
                            <h2 style='color: #0056b3;'>Login Notification</h2>
                            <p>Hello " . htmlspecialchars($_SESSION['user_name']) . ",</p>
                            <p>Your login was successful.</p>
                            <p>If this was not you, please contact support immediately.</p>
                            <footer style='margin-top: 20px; font-size: 0.9em; color: #777;'>&copy; " . date("Y") . " BLX Growth Group. All rights reserved.</footer>
                        </div>
                    </body>
                    </html>";

                    $mail->send();
                } catch (Exception $e) {
                    echo '<div class="alert alert-danger">Email error: ' . htmlspecialchars($e->getMessage()) . '</div>';
                }

                echo '<div class="alert alert-success">Login successful. Redirecting...</div>';
                // Redirect to another page if needed
                echo '<script>window.location.href = "../west-libery/swift/index";</script>';
            } else {
                echo '<div class="alert alert-warning">Please verify your email address first.</div>';
            }
        } else {
            echo '<div class="alert alert-danger">Invalid email or password.</div>';
        }
    } catch (PDOException $e) {
        // Display exact error in development; replace this with a generic message in production
        echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    } catch (Exception $e) {
        echo '<div class="alert alert-danger">Unexpected error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    }
}
?>
