<?php
session_start();

// Enable error reporting for debugging (should be disabled in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require '../swift/server/config.db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userInputOtp = $_POST['otp'];

    // Verify OTP securely
    if (isset($_SESSION['otp']) && password_verify($userInputOtp, $_SESSION['otp'])) {
        unset($_SESSION['otp']); // Clear OTP session
        $_SESSION['is_logged_in'] = true; // Set login session

        // Send login confirmation email
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
                    $mail->Host = 's3.whitelabelclouds.com';
                    $mail->SMTPAuth = true;
                    $mail->Username = 'no-reply@swiftheart.uk';
                    $mail->Password = 'whodeybreathe';
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                    $mail->Port = 587;

            $mail->setFrom('no-reply@swiftheart.uk', 'Swiftheart Confirmation');
            $mail->addAddress($_SESSION['user_email'], $_SESSION['user_name']);

            $mail->isHTML(true);
            $mail->Subject = 'Login Successful';
            $mail->Body = "
            <html>
            <body style='font-family: Arial, sans-serif; color: #333; text-align: center;'>
                <div style='max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 8px;'>
                    <h2 style='color: #0056b3;'>Login Notification</h2>
                    <p>Hello " . htmlspecialchars($_SESSION['user_name']) . ",</p>
                    <p>Your login was successful.</p>
                    <p>If this was not you, please contact support immediately.</p>
                    <footer style='margin-top: 20px; font-size: 0.9em; color: #777;'>&copy; " . date("Y") . " BLX Growth Services. All rights reserved.</footer>
                </div>
            </body>
            </html>";

            $mail->send();
        } catch (Exception $e) {
            // Log error details (not for user output)
            error_log("Email could not be sent. Error: {$mail->ErrorInfo}");
        }

        echo '<div class="alert alert-success">OTP verified. Logging you in...</div>';
        echo '<script>window.location.href = "dashboard.php";</script>';
    } else {
        echo '<div class="alert alert-danger">Invalid OTP. Please try again.</div>';
    }
} else {
    // Set OTP securely (for example purpose only)
    $otp = rand(100000, 999999);
    $_SESSION['otp'] = password_hash($otp, PASSWORD_BCRYPT);
    // Ideally, send this OTP via email or SMS at the time of generation.
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure Login</title>
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
        }
        .container {
            text-align: center;
            max-width: 400px;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .container h2 {
            color: #0056b3;
        }
        .container input[type="text"], .container button {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        .container button {
            background-color: #0056b3;
            color: white;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .container button:hover {
            background-color: #003f8a;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Enter OTP</h2>
        <p>Please enter the OTP sent to your email to confirm login.</p>
        <form method="POST">
            <input type="text" name="otp" placeholder="Enter OTP" required>
            <button type="submit">Verify OTP</button>
        </form>
    </div>
</body>
</html>
