<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - BLX Growth Services</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <style>
        body {
            background-color: #f3f4f6;
            font-family: Arial, sans-serif;
        }

        .register-container {
            width: 100%;
            max-width: 400px;
            margin: 50px auto;
            padding: 30px;
            background: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border: 1px solid #e5e5e5;
        }

        .register-container h3 {
            text-align: center;
            margin-bottom: 20px;
            font-size: 24px;
            font-weight: bold;
            color: #333333;
        }

        .register-container .form-group {
            margin-bottom: 20px;
        }

        .register-container .form-control {
            height: 45px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
            transition: 0.3s ease-in-out;
        }

        .register-container .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
        }

        .register-container .btn {
            width: 100%;
            height: 45px;
            font-size: 16px;
            background-color: #007bff;
            border: none;
            border-radius: 5px;
            color: #ffffff;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .register-container .btn:hover {
            background-color: #0056b3;
        }

        .register-container .link {
            text-align: center;
            margin-top: 15px;
            display: block;
            font-size: 14px;
            color: #007bff;
        }

        .register-container .link:hover {
            text-decoration: underline;
        }

        .note {
            font-size: 13px;
            color: #6c757d;
            margin-top: -10px;
        }

        @media (max-width: 767px) {
            .register-container {
                margin: 20px auto;
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="register-container">
        <form class="form-horizontal" id="registerForm" enctype="multipart/form-data" action="" method="post">
            <h3>Create Your Account</h3>
            <div class="logResult"></div>

            <div class="form-group">
                <input class="form-control" name="full_name" type="text" id="full_name" autocomplete="off" maxlength="100" placeholder="Full Name">
            </div>

            <div class="form-group">
                <input class="form-control" name="email" type="email" id="email" autocomplete="off" maxlength="100" placeholder="Email Address">
            </div>

            <div class="form-group">
                <span class="note">Phone number must start with a country code, e.g., +225</span>
                <input class="form-control" name="phone" type="text" id="phone" autocomplete="off" maxlength="15" placeholder="Phone Number">
            </div>

            <div class="form-group">
                <input class="form-control" name="address" type="text" id="address" autocomplete="off" maxlength="255" placeholder="Address">
            </div>

            <div class="form-group">
                <input class="form-control" name="password" type="password" id="password" placeholder="Password" autocomplete="off" maxlength="20">
            </div>

            <div class="form-group">
                <input class="form-control" name="confirm_password" type="password" id="confirm_password" placeholder="Confirm Password" autocomplete="off" maxlength="20">
            </div>

            <div class="form-group">
                <input class="form-control" name="pin" type="text" id="pin" placeholder="4-digit PIN" autocomplete="off" maxlength="4" inputmode="numeric" pattern="\d*">
            </div>

            <div class="form-group">
                <input class="form-control" name="confirm_pin" type="text" id="confirm_pin" placeholder="Confirm 4-digit PIN" autocomplete="off" maxlength="4" inputmode="numeric" pattern="\d*">
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary registerbtn">Register</button>
            </div>

            <a href="index.php" class="link">Already have an account? Sign in</a>
        </form>
    </div>
</body>
</html>

        
        <script type="text/javascript">
    $(document).ready(function() {
        // Initially disable the register button
        $('.registerbtn').prop('disabled', true);

        // Function to check if passwords and PINs match
        function checkInputsMatch() {
            var password = $('#password').val();
            var confirm_password = $('#confirm_password').val();
            var pin = $('#pin').val();
            var confirm_pin = $('#confirm_pin').val();
            if (password === confirm_password && password.length > 0 && pin === confirm_pin && pin.length === 4) {
                $('.registerbtn').prop('disabled', false);
            } else {
                $('.registerbtn').prop('disabled', true);
            }
        }

        // Event listener for input fields
        $('#password, #confirm_password, #pin, #confirm_pin').on('input', function() {
            checkInputsMatch();
        });

        $('.registerbtn').on('click', function() {
            var $this = $(this);
            var loadingText = '<i class="spinner-border spinner-border-sm text-light" role="status" aria-hidden="true"></i> Processing...';

            if ($(this).html() !== loadingText) {
                $this.data('original-text', $(this).html());
                $this.html(loadingText);
            }
            setTimeout(function() {
                $this.html($this.data('original-text'));
            }, 5000);
        });

        $('.registerbtn').click(function (e) {
            e.preventDefault();
            var full_name = $('#full_name').val();
            var email = $('#email').val();
            var phone = $('#phone').val();
            var address = $('#address').val();
            var password = $('#password').val();
            var confirm_password = $('#confirm_password').val();
            var pin = $('#pin').val();
            var confirm_pin = $('#confirm_pin').val();

            if (password !== confirm_password) {
                $('.logResult').html('<div class="alert alert-danger">Passwords do not match. Please check the password and try again!</div>');
                return;
            }

            if (pin !== confirm_pin) {
                $('.logResult').html('<div class="alert alert-danger">PINs do not match, please check pin and try again later</div>');
                return;
            }

            $.ajax({
                type: "POST",
                url: "register_handler.php",
                data: { 
                    "full_name": full_name, 
                    "email": email, 
                    "phone": phone, 
                    "address": address, 
                    "password": password,
                    "pin": pin
                },
                success: function (data) {
                    $('.logResult').html(data);
                    $('#registerForm')[0].reset();
                    $('.registerbtn').prop('disabled', true); // Disable button after form submission
                }
            });
        });
    });
</script>

    </div>
</body>
</html>
