<?php
// Enable error reporting for debugging (should be disabled in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require '../west-libery/swift/server/config.db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']);
    $password = trim($_POST['password']);
    $verification_token = bin2hex(random_bytes(16)); // Generate a random token
    $pin = $_POST['pin'] ?? '';

    $errors = [];

    // Validate email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Invalid email address.';
    }

    // Check for duplicate email
    $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
    $stmt->execute([$email]);
    if ($stmt->rowCount() > 0) {
        $errors[] = 'The email address is already registered. Please use a different email.';
    }

    // Validate phone number (example: should start with country code, e.g., +1 for US)
    if (!preg_match('/^\+\d{1,3}\d{4,14}(?:x.+)?$/', $phone)) {
        $errors[] = 'Phone number must start with a country code and be in a valid format.';
    }

    if (empty($errors)) {
        try {
            // Generate unique account number
            $account_number = generateUniqueAccountNumber($pdo);

            // Insert into database
            $stmt = $pdo->prepare('INSERT INTO users (full_name, email, phone, address, password, verification_token, account_number, pin) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
            $stmt->execute([$full_name, $email, $phone, $address, password_hash($password, PASSWORD_DEFAULT), $verification_token, $account_number, $pin]);

            // Send verification email
            $mail = new PHPMailer(true);
            try {
                // Server settings
    $mail->isSMTP();
    $mail->Host = 'mail.west-libertygroup.com'; // Set the SMTP server to send through
    $mail->SMTPAuth = true;
    $mail->Username = 'no-reply@west-libertygroup.com'; // SMTP username
    $mail->Password = 'whodeybreathe'; // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Use SMTPS for port 465
$mail->Port = 465; // SSL port


                //Recipients
                $mail->setFrom('no-reply@west-libertygroup.com', 'From Ziora - West Liberty services');
                $mail->addAddress($email, $full_name);

                // Content
                $mail->isHTML(true);
                $mail->Subject = 'Please Verify Your Email Address';
                
                $verification_link = "http://west-libertygroup.com/securepass/secure/authenticate/verify.php?token=" . $verification_token;
                
                $mail->Body = '
                <html>
                <head>
                    <style>
                        body {
                            font-family: Arial, sans-serif;
                            color: #333;
                            line-height: 1.6;
                        }
                        .container {
                            width: 100%;
                            max-width: 600px;
                            margin: 0 auto;
                            padding: 20px;
                            background: #f4f4f4;
                            border: 1px solid #ddd;
                            border-radius: 5px;
                        }
                        .header {
                            text-align: center;
                            padding-bottom: 20px;
                        }
                        .header img {
                            width: 60px;
                        }
                        .content {
                            padding: 20px;
                            background: #fff;
                            border-radius: 5px;
                            box-shadow: 0 0 10px rgba(0,0,0,0.1);
                        }
                        .content h2 {
                            color: #0056b3;
                        }
                        .footer {
                            text-align: center;
                            padding-top: 20px;
                            font-size: 0.9em;
                            color: #777;
                        }
                        .footer a {
                            color: #0056b3;
                            text-decoration: none;
                        }
                    </style>
                </head>
                <body>
                    <div class="container">
                        <div class="header">
                            <img src="https://west-libertygroup.com/images/favicon.png" alt="BLX GROWTH Logo">
                        </div>
                        <div class="content">
                            <h2>Hello ' . htmlspecialchars($full_name) . ',</h2>
                            <p>Thank you for registering with West Liberty!</p>
                            <p>Please verify your Account by clicking the link below:</p>
                            <p><a href="' . htmlspecialchars($verification_link) . '" style="display: inline-block; padding: 10px 20px; font-size: 16px; color: #fff; background-color: #0056b3; text-decoration: none; border-radius: 5px;">Verify Account</a></p>
                            <p>If you did not register for this account, please ignore this email.</p>
                        </div>
                        <div class="footer">
                            <p>&copy; ' . date("Y") . ' West Liberty. All rights reserved.</p>
                        </div>
                    </div>
                </body>
                </html>';

                $mail->send();
                echo '<div class="alert alert-success">Registration successful! Please check your email to verify your account.</div>';
            } catch (Exception $e) {
                echo '<div class="alert alert-danger">Registration successful, but failed to send verification email. Please try again later.</div>';
            }
        } catch (PDOException $e) {
    echo '<div class="alert alert-danger">An error occurred while processing your registration. Please try again later. Error: ' . $e->getMessage() . '</div>';
}

    } else {
        // Output validation errors
        foreach ($errors as $error) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
        }
    }
}

/**
 * Generates a unique 10-digit account number based on the current timestamp and random digits.
 *
 * @return string
 */
function generateUniqueAccountNumber() {
    // Generate a unique number using the current timestamp and a random number
    $timestamp = time(); // Current Unix timestamp
    $random = rand(1000, 9999); // Random 4-digit number

    // Concatenate timestamp and random number, and ensure it is exactly 10 digits long
    $account_number = substr($timestamp . $random, -10); 

    return $account_number;
}

?>
