<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .forgotbox {
            background: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
        }
        .forgotbox h3 {
            margin-bottom: 20px;
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        .form-control {
            border-radius: 4px;
            border: 1px solid #ced4da;
            box-shadow: none;
            height: 45px;
            padding: 10px 15px;
        }
        .btn-primary {
            background-color: #007bff;
            border: none;
            border-radius: 4px;
            height: 45px;
            font-size: 16px;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .logResult {
            margin-bottom: 20px;
        }
        .alert {
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="resetbox">
    <div class="innerreset" id="reset-form">
        <form class="form-horizontal" id="resetPasswordForm" enctype="multipart/form-data" action="" method="post">
            <h3>Reset Password</h3>
            <div class="logResult"></div>

            <div class="form-group">
                <input class="form-control" name="password" type="password" id="password" autocomplete="off" maxlength="20" placeholder="New Password">
            </div>

            <div class="form-group">
                <input class="form-control" name="confirm_password" type="password" id="confirm_password" autocomplete="off" maxlength="20" placeholder="Confirm Password">
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary resetbtn">Reset Password</button>
            </div>
        </form>
    </div>

    <script type="text/javascript">
       $(document).ready(function() {
            $('#resetPasswordForm').submit(function (e) {
                e.preventDefault();
                var password = $('#password').val();
                var confirm_password = $('#confirm_password').val();

                if (password !== confirm_password) {
                    $('.logResult').html('<div class="alert alert-danger">Passwords do not match.</div>');
                    return;
                }

                $.ajax({
                    type: "POST",
                    url: "reset_passwordp.php?token=" + new URLSearchParams(window.location.search).get('token'),
                    data: { "password": password, "confirm_password": confirm_password },
                    dataType: "json",
                    success: function (response) {
                        if (response.status === 'success') {
                            $('.logResult').html('<div class="alert alert-success">' + response.message + '</div>');
                        } else {
                            $('.logResult').html('<div class="alert alert-danger">' + response.message + '</div>');
                        }
                        $('#resetPasswordForm')[0].reset();
                    },
                    error: function (xhr, status, error) {
                        $('.logResult').html('<div class="alert alert-danger">An unexpected error occurred. Please try again later.</div>');
                    }
                });
            });
        });
    </script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

</div>
<style>
    /* General Styles */
body {
    font-family: Arial, sans-serif;
    color: #333;
    line-height: 1.6;
    background: #e9ecef;
    padding: 20px;
}

.resetbox {
    max-width: 600px;
    margin: 0 auto;
}

.innerreset {
    background: #fff;
    padding: 20px;
    border: 1px solid #ddd;
    border-radius: 5px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
}

h3 {
    text-align: center;
    color: #0056b3;
    margin-bottom: 20px;
}

.form-group {
    margin-bottom: 15px;
}

.form-control {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    box-sizing: border-box;
}

.btn-primary {
    background-color: #0056b3;
    border: none;
    color: #fff;
    padding: 10px 15px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 4px;
    width: 100%;
}

.btn-primary:hover {
    background-color: #004494;
}

.alert {
    padding: 10px;
    margin-bottom: 15px;
    border-radius: 4px;
    color: #fff;
}

.alert-success {
    background-color: #28a745;
}

.alert-danger {
    background-color: #dc3545;
}

</style>