<?php
header('Content-Type: application/json');

require '../../west-libery/swift/server/config.db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

if (!isset($_GET['token'])) {
    echo json_encode(['status' => 'error', 'message' => 'Token is missing.']);
    exit();
}

$token = $_GET['token'];

if (!isset($_POST['password'], $_POST['confirm_password'])) {
    echo json_encode(['status' => 'error', 'message' => 'Please fill in all fields.']);
    exit();
}

$password = $_POST['password'];
$confirm_password = $_POST['confirm_password'];

$error = '';
if (empty($password) || empty($confirm_password)) {
    $error = 'Please fill in both password fields.';
} elseif ($password !== $confirm_password) {
    $error = 'Passwords do not match.';
} elseif (strlen($password) < 6) {
    $error = 'Password must be at least 6 characters long.';
}

if ($error) {
    echo json_encode(['status' => 'error', 'message' => $error]);
    exit();
}

try {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE reset_token = ? AND reset_expires > NOW()');
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid or expired token.']);
        exit();
    }

    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare('UPDATE users SET password = ?, reset_token = NULL, reset_expires = NULL WHERE reset_token = ?');
    $stmt->execute([$hashedPassword, $token]);

    echo json_encode(['status' => 'success', 'message' => 'Password reset successfully.']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}