<?php
require '../../../west-libery/swift/server/config.db.php';

$response = '';

if (isset($_GET['token'])) {
    $token = $_GET['token'];

    // Verify the token
    $stmt = $pdo->prepare('SELECT id, is_verified FROM users WHERE verification_token = ?');
    $stmt->execute([$token]);
    $user = $stmt->fetch();

    if ($user && !$user['is_verified']) {
        // Update user to verified
        $stmt = $pdo->prepare('UPDATE users SET is_verified = 1, verification_token = NULL WHERE id = ?');
        $stmt->execute([$user['id']]);

        $response = '<div class="alert alert-success">Email verification successful! You can now log in.</div>';
    } else {
        $response = '<div class="alert alert-danger">Invalid or expired verification link.</div>';
    }
} else {
    $response = '<div class="alert alert-danger">No verification token provided.</div>';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <style>
        .verification-container {
            width: 90%;
            max-width: 500px;
            margin: 50px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
            background-color: #f9f9f9;
            box-shadow: 0px 0px 10px 0px #000;
            text-align: center;
        }
        .loader {
            border: 8px solid #f3f3f3;
            border-radius: 50%;
            border-top: 8px solid #3498db;
            width: 60px;
            height: 60px;
            animation: spin 2s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="verification-container">
        <div class="loader" id="loader"></div>
        <div id="response" style="display: none;">
            <?php echo $response; ?>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Hide the loader and show the response message after 3 seconds
            setTimeout(function() {
                document.getElementById('loader').style.display = 'none';
                document.getElementById('response').style.display = 'block';
            }, 3000);

            // Redirect to the specified URL after 3 seconds
            setTimeout(function() {
                window.location.href = "https://west-libertygroup.com/securepass/index";
            }, 3000);
        });
    </script>
</body>
</html>
