<?php
require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

$stmt = $pdo->query('SELECT id, full_name, balance, account_number, card, frozen, email FROM users');
$users = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
    <link rel="shortcut icon" href="https://swifttess.com/swift/logo.png">
    <script>
        function checkUserActiveStatus() {
            fetch('server/active-check.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.active) {
                        alert('You have been logged out due to inactivity.');
                        window.location.href = 'logout.php';
                    }
                })
                .catch(error => console.error('Error:', error));
        }
        setInterval(checkUserActiveStatus, 30000);
    </script>
</head>
<body>
    <?php require 'server/active-check.php' ?>
    <?php require 'server/nav.php'; ?>
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>
    <?php require 'server/sidebar.php'; ?>

    <div class="container-fluid mt-5">
        <h2>Add Bank Details</h2>
        <form action="server/new_bank.php" method="POST">
            <div class="mb-3">
                <label for="bankName" class="form-label">Bank Name</label>
                <input type="text" class="form-control" id="bankName" name="bank_name" required>
            </div>
            <div class="mb-3">
                <label for="swiftCode" class="form-label">Swift Code</label>
                <input type="text" class="form-control" id="swiftCode" name="swift_code" required>
            </div>
            <div class="mb-3">
                <label for="beneficiaryAccountName" class="form-label">Beneficiary Account Name</label>
                <input type="text" class="form-control" id="beneficiaryAccountName" name="beneficiary_account_name" required>
            </div>
            <div class="mb-3">
                <label for="beneficiaryAccountNumber" class="form-label">Beneficiary Account Number</label>
                <input type="text" class="form-control" id="beneficiaryAccountNumber" name="beneficiary_account_number" required>
            </div>
            <div class="mb-3">
                <label for="routingNumber" class="form-label">Routing Number</label>
                <input type="text" class="form-control" id="routingNumber" name="routing_number" required>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</body>
</html>
