<?php
require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$userId) {
    echo "Invalid user ID.";
    exit();
}

// Fetch transactions where the user's ID matches sender_id or receiver_id
$stmt = $pdo->prepare("
    SELECT id, transaction_type, created_at 
    FROM transactions 
    WHERE sender_id = :user_id OR receiver_id = :user_id 
    ORDER BY created_at DESC
");
$stmt->execute(['user_id' => $userId]);
$transactions = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backdate Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
    <link rel="shortcut icon" href="https://swifttess.com/swift/logo.png">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>
    <?php require 'server/active-check.php'; ?>
    <?php require 'server/nav.php'; ?>

    <div class="container mt-4">
        <h2>Backdate Transactions</h2>
        <p>Listing transactions for user ID: <strong><?php echo htmlspecialchars($userId); ?></strong></p>
        <ul class="list-group">
            <?php if ($transactions): ?>
                <?php foreach ($transactions as $transaction): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <strong><?php echo htmlspecialchars($transaction['transaction_type']); ?></strong><br>
                            <small><?php echo htmlspecialchars($transaction['created_at']); ?></small>
                        </div>
                        <button class="btn btn-sm btn-warning" 
                                data-bs-toggle="modal" 
                                data-bs-target="#editDateModal" 
                                data-transaction-id="<?php echo $transaction['id']; ?>" 
                                data-current-date="<?php echo $transaction['created_at']; ?>">
                            Edit Date
                        </button>
                    </li>
                <?php endforeach; ?>
            <?php else: ?>
                <li class="list-group-item">No transactions found for this user.</li>
            <?php endif; ?>
        </ul>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="editDateModal" tabindex="-1" aria-labelledby="editDateModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editDateModalLabel">Edit Transaction Date</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editDateForm">
                        <input type="hidden" id="transactionId" name="transaction_id">
                        <div class="mb-3">
                            <label for="year" class="form-label">Year</label>
                            <select id="year" class="form-select">
                                <?php for ($i = date('Y'); $i >= 2000; $i--): ?>
                                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="month" class="form-label">Month</label>
                            <select id="month" class="form-select">
                                <?php for ($i = 1; $i <= 12; $i++): ?>
                                    <option value="<?php echo str_pad($i, 2, '0', STR_PAD_LEFT); ?>">
                                        <?php echo date('F', mktime(0, 0, 0, $i, 1)); ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="day" class="form-label">Day</label>
                            <select id="day" class="form-select">
                                <?php for ($i = 1; $i <= 31; $i++): ?>
                                    <option value="<?php echo str_pad($i, 2, '0', STR_PAD_LEFT); ?>"><?php echo $i; ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="time" class="form-label">Time</label>
                            <input type="time" id="time" class="form-control">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="submitEditDate()">Save Changes</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        const editDateModal = document.getElementById('editDateModal');
        editDateModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const transactionId = button.getAttribute('data-transaction-id');
            const currentDate = button.getAttribute('data-current-date');

            const [year, month, day, time] = currentDate.split(/[- :]/);
            document.getElementById('transactionId').value = transactionId;
            document.getElementById('year').value = year;
            document.getElementById('month').value = month;
            document.getElementById('day').value = day;
            document.getElementById('time').value = time.slice(0, 5);
        });

        function submitEditDate() {
            const transactionId = document.getElementById('transactionId').value;
            const year = document.getElementById('year').value;
            const month = document.getElementById('month').value;
            const day = document.getElementById('day').value;
            const time = document.getElementById('time').value;

            const newDate = `${year}-${month}-${day} ${time}:00`;

            fetch('update_date.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ transaction_id: transactionId, new_date: newDate })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Date updated successfully!');
                    location.reload();
                } else {
                    alert('Failed to update date: ' + data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>
</body>
</html>

