<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

// Fetch the latest message and message count for each user_id
try {
    $query = "
        SELECT m1.user_id, m1.sender_name, LEFT(m1.content, 50) AS content_preview, m1.created_at, COUNT(m2.user_id) AS message_count
        FROM messages m1
        INNER JOIN (
            SELECT user_id, MAX(created_at) AS latest_created_at
            FROM messages
            GROUP BY user_id
        ) m2 ON m1.user_id = m2.user_id AND m1.created_at = m2.latest_created_at
        GROUP BY m1.user_id
        ORDER BY m1.created_at DESC
    ";
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Query failed: " . $e->getMessage();
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
</head>
<body>
    <?php require 'server/active-check.php' ?>
    <?php require 'server/nav.php'; ?>
    
    <!-- Sidebar trigger button for mobile -->
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar -->
    <?php require 'server/sidebar.php'; ?>

    <div class="container-fluid mt-5">
        <div class="row mt-3" id="user-list">
            <!-- Display the latest message preview for each user with a badge for message count -->
            <?php foreach ($messages as $row): ?>
                <div class="col-12 mb-3">
                    <div class="card">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="card-title"><?php echo htmlspecialchars($row['sender_name']); ?></h5>
                                <p class="card-text"><?php echo htmlspecialchars($row['content_preview']); ?>...</p>
                                <p class="card-text"><small class="text-muted">Sent on: <?php echo htmlspecialchars($row['created_at']); ?></small></p>
                            </div>
                            <span class="badge bg-primary">
                                <?php echo htmlspecialchars($row['message_count']); ?>
                            </span>
                        </div>
                        <a href="view_message.php?user_id=<?php echo $row['user_id']; ?>" class="btn btn-primary">
                            View & Reply
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</body>
</html>
