<?php
require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

$stmt = $pdo->query('SELECT id, full_name, balance, account_number, card, vat, frozen, admin_vat, currency, symbol, email FROM users');
$users = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="https://swiftheart.uk/swift/logo.png">
    <script>
        function checkUserActiveStatus() {
            fetch('server/active-check.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.active) {
                        alert('You have been logged out due to inactivity.');
                        window.location.href = 'logout.php';
                    }
                })
                .catch(error => console.error('Error:', error));
        }

        // Check every 30 seconds
        setInterval(checkUserActiveStatus, 30000);
    </script>
</head>
<body>
    <?php require 'server/active-check.php' ?>
    <?php require 'server/nav.php'; ?>
    <!-- Sidebar trigger button for mobile -->
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar -->
    <?php require 'server/sidebar.php'; ?>

    <div class="container-fluid mt-5">
    <div class="row">
    <div class="col-md-4">
        <input type="text" id="search" class="form-control" placeholder="Search Users...">
    </div>
    <!-- Button to open the currency.php page -->
<button class="btn btn-primary" onclick="window.location.href='currency.php';">
    Change Swiftheart Currency
</button>




</div>
<div class="row mt-3" id="user-list">
    <!-- Users will be dynamically loaded here -->
    <?php foreach ($users as $user): ?>
    <div class="col-md-4">
        <div class="user-card">
            <h5><?php echo htmlspecialchars($user['full_name']); ?></h5>
            <div class="user-info">
                <p><strong>Account Number:</strong> <?php echo htmlspecialchars($user['account_number']); ?></p>
                <b><strong>VAT:</strong> <?php echo htmlspecialchars($user['admin_vat']); ?></b>
                <p><strong>Balance:</strong> $<?php echo htmlspecialchars($user['balance']); ?></p>
                <?php if ($user['frozen'] == 1): ?>
                    <p><strong>Account Status:</strong> Account Frozen</p>
                <?php endif; ?>

                <p>
                    <span class="status-indicator <?php echo $user['card'] == 1 ? 'green' : 'red'; ?>"></span>
                    <strong>Card Status:</strong> <?php echo $user['card'] == 1 ? 'Active' : 'Inactive'; ?>
                </p>

                <!-- Display Currency -->
                <p><strong>Currency:</strong> 
                    <?php 
                    if (!empty($user['currency']) && !empty($user['symbol'])) {
                        echo htmlspecialchars($user['currency']) . ' (' . htmlspecialchars($user['symbol']) . ')';
                    } else {
                        echo 'DEFAULT CURRENCY';
                    }
                    ?>
                </p>
            </div>
            <div class="manage-actions">
                <button class="btn btn-success btn-sm fund-btn" data-account="<?php echo $user['account_number']; ?>">Fund</button>
                <button class="btn btn-danger btn-sm delete-btn" data-account="<?php echo $user['account_number']; ?>">Delete</button>
                <button class="btn btn-warning btn-sm freeze-btn" 
                    data-account="<?php echo $user['account_number']; ?>" 
                    data-frozen="<?php echo $user['frozen']; ?>">
                    <?php echo $user['frozen'] == 1 ? 'Unfreeze' : 'Freeze'; ?>
                </button>
                <a href="mail.php?id=<?php echo $user['id']; ?>" class="btn btn-primary btn-sm">E-mail</a>
                <!--<a href="backdate.php?id=<?//php echo $user['id']; ?>" class="btn btn-secondary btn-sm">BackDate</a>-->
                <!-- Add VAT Button -->
<button class="btn btn-info btn-sm toggle-vat-btn" 
        data-account="<?php echo $user['account_number']; ?>" 
        data-vat-status="<?php echo $user['vat']; ?>" 
        data-admin-vat="<?php echo $user['admin_vat']; ?>">
    <?php 
    echo ($user['vat'] == 1 && !empty($user['admin_vat'])) 
        ? 'Remove VAT' 
        : 'Add VAT'; 
    ?>
</button>

            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>



<!-- Modals -->
<div id="vat-loader-container" class="vat-loader-container" style="display: none;">
    <div class="vat-loader-message">
        <h5>Hold On</h5>
        <p>VAT code is being generated...</p>
        <div class="loader"></div>
    </div>
</div>

<style>
.vat-loader-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

.vat-loader-message {
    text-align: center;
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
}

.loader {
    border: 5px solid #f3f3f3;
    border-top: 5px solid #3498db;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 20px auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).on('click', '.toggle-vat-btn', function () {
    const accountNumber = $(this).data('account');
    const vatStatus = $(this).data('vat-status');
    const adminVat = $(this).data('admin-vat');

    const action = (vatStatus == 1 && adminVat) ? 'remove' : 'add';
    const confirmMessage = action === 'remove' 
        ? 'Are you sure you want to remove VAT?' 
        : 'Are you sure you want to add VAT?';

    if (!confirm(confirmMessage)) return;

    // Show loader
    $('#vat-loader-container').fadeIn();

    // Send AJAX request to update VAT
    $.ajax({
        url: 'generate_vat.php',
        method: 'POST',
        data: { account_number: accountNumber, action: action },
        success: function (response) {
            $('#vat-loader-container').fadeOut();

            const data = JSON.parse(response);
            if (data.success) {
                alert(data.message);

                // Update button text and attributes dynamically
                const button = $(`button[data-account='${accountNumber}']`);
                button.data('vat-status', data.vat_status);
                button.data('admin-vat', data.admin_vat);
                button.text(data.vat_status == 1 ? 'Remove VAT' : 'Add VAT');
            } else {
                alert('Error: ' + data.message);
            }
        },
        error: function () {
            $('#vat-loader-container').fadeOut();
            alert('An error occurred. Please try again.');
        }
    });
});
</script>

<!-- Fund Modal -->
<div class="modal fade" id="fundModal" tabindex="-1" aria-labelledby="fundModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="fundModalLabel">Fund User Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="fundForm">
                    <div class="mb-3">
                        <label for="fundAmount" class="form-label">Amount</label>
                        <input type="number" class="form-control" id="fundAmount" required>
                        <input type="hidden" id="fundAccountNumber">
                    </div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this user? This action cannot be undone.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeletess">Delete</button>
            </div>
        </div>
    </div>
</div>

<!-- Freeze/Unfreeze Confirmation Modal -->
<div class="modal fade" id="freezeModal" tabindex="-1" aria-labelledby="freezeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="freezeModalLabel">Confirm Action</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to <span id="freezeAction"></span> this user? This action can be reversed.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-warning" id="confirmFreeze">Confirm</button>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>

document.addEventListener('DOMContentLoaded', function () {
    const vatButtons = document.querySelectorAll('.toggle-vat-btn');
    
    vatButtons.forEach(button => {
        button.addEventListener('click', function () {
            const accountNumber = this.getAttribute('data-account');
            const currentVatStatus = this.getAttribute('data-vat-status');
            const newVatStatus = currentVatStatus == 1 ? 0 : 1; // Toggle VAT status

            // Send an AJAX request to update the VAT status in the database
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'update_vat.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);

                    if (response.status === 'success') {
                        // Update the button text and data-vat-status
                        const newText = newVatStatus == 1 ? 'Remove VAT' : 'Add VAT';
                        button.textContent = newText;
                        button.setAttribute('data-vat-status', newVatStatus);
                    } else {
                        alert('Error updating VAT status');
                    }
                }
            };
            xhr.send('account_number=' + encodeURIComponent(accountNumber) + '&vat=' + newVatStatus);
        });
    });
});
   
$('#newCurrencyForm').on('submit', function (e) {
    e.preventDefault(); // Prevent the default form submission
    var selectedCurrency = $('#newCurrencySelect').val();
    var selectedSymbol = $('#newCurrencySelect option:selected').data('symbol'); // Retrieve the symbol

    if (selectedCurrency) {
        $.ajax({
            url: 'server/change_currency.php', // Backend endpoint
            type: 'POST',
            data: {
                currency: selectedCurrency,
                symbol: selectedSymbol,
            },
            success: function (response) {
                response = JSON.parse(response);
                if (response.success) {
                    alert('Currency updated successfully!');
                    $('#newCurrencyModal').modal('hide');
                    window.location.href = '../dashboard'; // Redirect to the dashboard
                } else {
                    alert('Failed to update currency: ' + response.message);
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX error:', error);
                alert('An error occurred. Please try again.');
            },
        });
    } else {
        alert('Please select a currency.');
    }
});

    $(document).ready(function() {
    var accountNumber;

    // Handle Fund button click
    $('.fund-btn').click(function() {
        accountNumber = $(this).data('account');
        $('#fundAccountNumber').val(accountNumber);
        $('#fundModal').modal('show');
    });

    // Handle Fund form submission
    $('#fundForm').submit(function(e) {
        e.preventDefault();
        var amount = $('#fundAmount').val();
        $.ajax({
            url: 'server/fund_user.php',
            type: 'POST',
            data: { account_number: accountNumber, amount: amount },
            success: function(response) {
                response = JSON.parse(response);
                if (response.success) {
                    alert('Account funded successfully.');
                    location.reload();
                } else {
                    alert('Failed to fund account. Please try again.');
                }
            },
            error: function(xhr, status, error) {
                console.error("Error occurred: " + error); // Debugging
            }
        });
    });
});

    $(document).ready(function() {
    var actionType;
    var accountNumber;

    // Search functionality
    $('#search').on('input', function() {
        var query = $(this).val();
        $.ajax({
            url: 'server/search_users.php',
            type: 'GET',
            data: { q: query },
            success: function(response) {
                $('#user-list').html(response);
            }
        });
    });

    $('.delete-btn').click(function() {
        accountNumber = $(this).data('account');
        console.log("Account to delete: " + accountNumber); // Debugging
        actionType = 'delete';
        $('#deleteModal').modal('show');
    });

    $('#confirmDeletess').click(function() {
        if (actionType === 'delete') {
            $.ajax({
                url: 'server/delete_user.php',
                type: 'POST',
                data: { account_number: accountNumber },
                success: function(response) {
                    response = JSON.parse(response);
                    console.log(response); // Debugging
                    if (response.success) {
                        console.log("User deleted successfully."); // Debugging
                        location.reload();
                    } else {
                        alert('Failed to delete user. Please try again.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error occurred: " + error); // Debugging
                }
            });
        }
    });
});
$(document).ready(function() {
    var accountNumber;
    var isFreezeAction;

    // Handle Freeze button click
    $('.freeze-btn').click(function() {
        accountNumber = $(this).data('account');
        var isFrozen = $(this).data('frozen');
        
        // Set modal text and action based on freeze/unfreeze state
        if (isFrozen == 1) {
            isFreezeAction = false; // Unfreeze action
            $('#freezeModalLabel').text('Confirm Unfreeze');
            $('#freezeAction').text('unfreeze');
            $('#confirmFreeze').text('Unfreeze');
        } else {
            isFreezeAction = true; // Freeze action
            $('#freezeModalLabel').text('Confirm Freeze');
            $('#freezeAction').text('freeze');
            $('#confirmFreeze').text('Freeze');
        }

        // Show the modal
        $('#freezeModal').modal('show');
    });

    // Handle confirmation of Freeze/Unfreeze action
    $('#confirmFreeze').click(function() {
        var actionUrl = isFreezeAction ? 'server/freeze_user.php' : 'server/unfreeze_user.php';

        $.ajax({
            url: actionUrl,
            type: 'POST',
            data: { account_number: accountNumber },
            success: function(response) {
                response = JSON.parse(response);
                if (response.success) {
                    alert(isFreezeAction ? 'User account frozen successfully.' : 'User account unfrozen successfully.');
                    location.reload();
                } else {
                    alert('Failed to update account status. Please try again.');
                }
            },
            error: function(xhr, status, error) {
                console.error("Error occurred: " + error);
            }
        });
    });
});


</script>

</body>
</html>
