<?php
require 'server/config.db.php'; // Ensure database connection is included

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accountNumber = $_POST['account_number'];
    $action = $_POST['action'];

    try {
        // Fetch user record by account number
        $query = "SELECT vat, admin_vat, vat_verified FROM users WHERE account_number = :account_number";
        $stmt = $pdo->prepare($query);
        $stmt->execute([':account_number' => $accountNumber]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            echo json_encode(['success' => false, 'message' => 'User not found']);
            exit();
        }

        // Determine action (add/remove VAT)
        if ($action === 'add') {
            $vatCode = rand(1000, 9999); // Generate a 4-digit VAT code
            $query = "UPDATE users SET vat = 1, admin_vat = :vat_code WHERE account_number = :account_number";
            $stmt = $pdo->prepare($query);
            $stmt->execute([':vat_code' => $vatCode, ':account_number' => $accountNumber]);

            echo json_encode(['success' => true, 'message' => 'VAT added successfully', 'vat_status' => 1, 'admin_vat' => $vatCode]);
        } elseif ($action === 'remove') {
            $query = "UPDATE users SET vat = 0, vat_verified = 0, admin_vat = NULL WHERE account_number = :account_number";
            $stmt = $pdo->prepare($query);
            $stmt->execute([':account_number' => $accountNumber]);

            echo json_encode(['success' => true, 'message' => 'VAT removed successfully', 'vat_status' => 0, 'vat_verified' => 0, 'admin_vat' => null]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
