<?php
// Enable error reporting for debugging (should be disabled in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'server/config.db.php';

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

// Fetch users who do not have a card
$stmt = $pdo->query('SELECT id, full_name FROM users WHERE card = 0');
$users = $stmt->fetchAll();

function generateCardNumber() {
    return '5' . str_pad(rand(0, 999999999999999), 15, '0', STR_PAD_LEFT);
}

function generateCVV() {
    return str_pad(rand(0, 999), 3, '0', STR_PAD_LEFT);
}

function generateExpirationDate() {
    return date('m/y', strtotime('+2 years'));
}

// Handle card creation and preview
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['preview_card'])) {
    $userId = $_POST['user_id'];
    $userStmt = $pdo->prepare('SELECT full_name FROM users WHERE id = ?');
    $userStmt->execute([$userId]);
    $user = $userStmt->fetch();

    $cardNumber = generateCardNumber();
    $cvv = generateCVV();
    $expiryDate = generateExpirationDate();
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_card'])) {
    $userId = $_POST['user_id'];
    $cardNumber = $_POST['card_number'];
    $cvv = $_POST['card_cvv'];
    $expiryDate = $_POST['card_expiry'];
    
    // Update the user's record with the new card number and details
    $stmt = $pdo->prepare("UPDATE users SET card = 1, card_number = ?, card_cvv = ?, card_expiry = ? WHERE id = ?");
    $stmt->execute([$cardNumber, $cvv, $expiryDate, $userId]);

    // Redirect to the same page to refresh the table
    header('Location: create_card.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
</head>
<body>
    <?php require 'server/nav.php'; ?>
    <!-- Sidebar trigger button for mobile -->
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar -->
    <?php require 'server/sidebar.php'; ?>
    <style>
        .card-table {
            margin-top: 20px;
        }
        .card-preview {
            margin-top: 20px;
            display: flex;
            justify-content: center;
        }
        .card {
            width: 320px;
            height: 200px;
            border-radius: 10px;
            background: linear-gradient(to bottom right, #4a90e2, #0033a0);
            color: #fff;
            padding: 20px;
            position: relative;
            font-family: 'Arial', sans-serif;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .card-logo-top {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 60px;
        }
        .card-logo-bottom {
            position: absolute;
            bottom: 15px;
            right: 15px;
            width: 80px;
            opacity: 0.8;
        }
        .card-brand {
            font-size: 1.5em;
            color: #f1c40f;
            font-weight: bold;
        }
        .card-number {
            font-size: 1.6em;
            letter-spacing: 2px;
            margin-top: 50px;
        }
        .card-expiry,
        .card-cvv {
            font-size: 0.9em;
        }
        .card-expiry {
            text-align: left;
        }
        .card-cvv {
            text-align: left;
        }
        .card-name {
            font-size: 0.9em;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h1>Create MasterCard</h1>

    <?php if (isset($user)): ?>
        <div class="card-preview">
            <div class="card">
                <img src="../logo.jpeg" alt="MasterCard Logo" class="card-logo-top">
                <div class="card-number"><?php echo htmlspecialchars($cardNumber); ?></div>
                <div class="card-cvv">CVV: <?php echo htmlspecialchars($cvv); ?></div>
                <div class="card-expiry">Expires: <?php echo htmlspecialchars($expiryDate); ?></div>
                <div class="card-name"><?php echo htmlspecialchars($user['full_name']); ?></div>
                <img src="card.png" alt="MasterCar" class="card-logo-bottom">
            </div>
        </div>
        
        <form method="post" class="mt-3">
            <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($userId); ?>">
            <input type="hidden" name="card_number" value="<?php echo htmlspecialchars($cardNumber); ?>">
            <input type="hidden" name="card_cvv" value="<?php echo htmlspecialchars($cvv); ?>">
            <input type="hidden" name="card_expiry" value="<?php echo htmlspecialchars($expiryDate); ?>">
            <button type="submit" name="confirm_card" class="btn btn-success">Confirm and Save Card</button>
        </form>
    <?php else: ?>
        <table class="table table-bordered card-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Full Name</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['id']); ?></td>
                    <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                    <td>
                        <form method="post">
                            <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($user['id']); ?>">
                            <button type="submit" name="preview_card" class="btn btn-primary">Create Card</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
