<?php
require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

$stmt = $pdo->query('SELECT id, bank_name, swift_code, beneficiary_account_name, beneficiary_account_number, routing_number, created_at FROM bank_details');
$banks = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank Details</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
    <link rel="shortcut icon" href="https://swifttess.com/swift/logo.png">
    <script>
        function checkUserActiveStatus() {
            fetch('server/active-check.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.active) {
                        alert('You have been logged out due to inactivity.');
                        window.location.href = 'logout.php';
                    }
                })
                .catch(error => console.error('Error:', error));
        }
        setInterval(checkUserActiveStatus, 30000);
    </script>
</head>
<body>
    <?php require 'server/active-check.php' ?>
    <?php require 'server/nav.php'; ?>
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>
    <?php require 'server/sidebar.php'; ?>


    <div class="container-fluid mt-5">
        <h2>Bank Details</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Bank Name</th>
                    <th>Swift Code</th>
                    <th>Beneficiary Account Name</th>
                    <th>Beneficiary Account Number</th>
                    <th>Routing Number</th>
                    <th>Date Added</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($banks as $bank): ?>
                    <tr>
                        <td><?= htmlspecialchars($bank['id']) ?></td>
                        <td><?= htmlspecialchars($bank['bank_name']) ?></td>
                        <td><?= htmlspecialchars($bank['swift_code']) ?></td>
                        <td><?= htmlspecialchars($bank['beneficiary_account_name']) ?></td>
                        <td><?= htmlspecialchars($bank['beneficiary_account_number']) ?></td>
                        <td><?= htmlspecialchars($bank['routing_number']) ?></td>
                        <td><?= htmlspecialchars($bank['created_at']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
