<?php
require 'server/config.db.php';

if (!isset($_GET['id'])) {
    header('Location: index.php'); // Redirect if no ID is provided
    exit();
}

$userId = $_GET['id'];

// Fetch user details
$stmt = $pdo->prepare('SELECT email, full_name FROM users WHERE id = ?');
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    header('Location: index.php'); // Redirect if user not found
    exit();
}

$recipientEmail = htmlspecialchars($user['email']);
$recipientName = htmlspecialchars($user['full_name']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Send Email</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Send Email to <?php echo $recipientName; ?></h2>
    <form action="send_email.php" method="post">
        <input type="hidden" name="recipient_email" value="<?php echo $recipientEmail; ?>">
        <input type="hidden" name="recipient_name" value="<?php echo $recipientName; ?>">
        <div class="mb-3">
            <label for="subject" class="form-label">Subject</label>
                <select class="form-select" id="subject" name="subject" required>
                    <option value="" disabled selected>Select a Subject</option>
                    <option value="Swiftess Support">BLX GROWTH Support</option>
                    <option value="Support Team">Support Team</option>
                    <option value="Notification (BLX GROWTH)">Notification (BLX GROWTH)</option>
                    <option value="Eliora from BLX GROWTH">Eliora from BLX GROWTH</option>
                    <option value="Thiago from BLX GROWTH">Thiago from BLX GROWTH</option>
                    <option value="Ingrid from BLX GROWTH">Ingrid from BLX GROWTH</option>
                    <option value="Sophia from BLX GROWTH">Sophia from BLX GROWTH</option>
                </select>
            </div>

        <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Send Email</button>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
