<?php
require 'server/config.db.php';

$recipientEmail = '';
$recipientName = '';

// Fetch single user details if an ID is provided
if (isset($_GET['id'])) {
    $userId = $_GET['id'];

    $stmt = $pdo->prepare('SELECT email, full_name FROM users WHERE id = ?');
    $stmt->execute([$userId]);
    $user = $stmt->fetch();

    if (!$user) {
        header('Location: index.php'); // Redirect if user not found
        exit();
    }

    $recipientEmail = htmlspecialchars($user['email']);
    $recipientName = htmlspecialchars($user['full_name']);
}

// Fetch all users' emails and names
$stmt = $pdo->query('SELECT email, full_name FROM users');
$allUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
$allEmails = implode(',', array_column($allUsers, 'email'));
$allNames = implode(', ', array_column($allUsers, 'full_name'));
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
</head>
<body>
    <?php require 'server/nav.php'; ?>
    <!-- Sidebar trigger button for mobile -->
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar -->
    <?php require 'server/sidebar.php'; ?>
<div class="container mt-5">
    <h2>Send Email</h2>
    <form action="special_mail.php" method="post">
        <!-- Type of Recipient -->
        <div class="mb-3">
            <label for="recipientType" class="form-label">Type of Recipient</label>
            <select class="form-select" id="recipientType" name="recipient_type" required>
                <option value="" disabled selected>Select Recipient Type</option>
                <option value="single">Single User</option>
                <option value="all">All Users</option>
            </select>
        </div>

        <!-- Email and Name Input for Single User -->
        <div id="singleUserFields" style="display: none;">
            <div class="mb-3">
                <label for="recipientEmail" class="form-label">Recipient Email</label>
                <input type="email" class="form-control" id="recipientEmail" name="recipient_email" value="<?php echo $recipientEmail; ?>">
            </div>
            <div class="mb-3">
                <label for="recipientName" class="form-label">Recipient Name</label>
                <input type="text" class="form-control" id="recipientName" name="recipient_name" value="<?php echo $recipientName; ?>">
            </div>
        </div>

        <!-- Hidden fields for all users -->
        <input type="hidden" id="allUserEmails" name="all_user_emails" value="<?php echo $allEmails; ?>">
        <input type="hidden" id="allUserNames" name="all_user_names" value="<?php echo $allNames; ?>">

        <!-- Subject -->
        <div class="mb-3">
            <label for="subject" class="form-label">Subject</label>
            <select class="form-select" id="subject" name="subject" required>
                <option value="" disabled selected>Select a Subject</option>
                <option value="West Liberty Support">West Liberty Group Support</option>
                <option value="Support Team">Support Team</option>
                <option value="Notification (West Liberty)">Notification (West Liberty Group)</option>
                <option value="Eliora from West Liberty">Eliora from West Liberty Group</option>
                <option value="Thiago from West Liberty">Thiago from West Liberty Group</option>
                <option value="Ingrid from West Liberty">Ingrid from West Liberty Groups</option>
                <option value="Sophia from West Liberty">Sophia from West Liberty Group</option>
                <option valur="Login Notification"> Login Notification</option>
                <option value="Scheduled Maintenance Notice">Scheduled Maintenance Notice</option>
            </select>
        </div>

        <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
        </div>

        <button type="submit" class="btn btn-primary">Send Email</button>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.getElementById('recipientType').addEventListener('change', function() {
        var recipientType = this.value;
        var singleUserFields = document.getElementById('singleUserFields');

        if (recipientType === 'single') {
            singleUserFields.style.display = 'block';
            document.getElementById('recipientEmail').required = true;
            document.getElementById('recipientName').required = true;
        } else if (recipientType === 'all') {
            singleUserFields.style.display = 'none';
            document.getElementById('recipientEmail').required = false;
            document.getElementById('recipientName').required = false;
        }
    });
</script>
</body>
</html>
