<?php
require 'config.db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Capture posted data
    $currency = $_POST['currency'];
    $symbol = $_POST['symbol'];

    try {
        // Delete any existing currency setting
        $stmt = $pdo->prepare('DELETE FROM settings');
        $stmt->execute();

        // Insert the new currency setting
        $stmt = $pdo->prepare('INSERT INTO settings (currency, symbol) VALUES (:currency, :symbol)');
        $stmt->bindParam(':currency', $currency);
        $stmt->bindParam(':symbol', $symbol);
        $stmt->execute();

        // Return success response
        echo json_encode(['success' => true]);
    } catch (PDOException $e) {
        // Return failure response with the error message
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
