<?php
// Enable all error reporting
error_reporting(E_ALL);

// Display errors to the browser
ini_set('display_errors', 1);

// Log errors to a file (optional)
ini_set('log_errors', 1);
ini_set('error_log', 'errors.log');

// Include your database connection
require 'config.db.php';

// Ensure that the database connection is established
if (!$pdo) {
    die("Database connection failed!");
} else {
    echo "Database connection successful.<br>";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Capture posted data
    $currency = $_POST['currency'];
    $symbol = $_POST['symbol'];  // Symbol will be set when a currency is selected
    $userId = $_POST['user_id'];

    // Forcefully proceed with database upload regardless of checks
    try {
        // Prepare and execute the update statement
        $updateStmt = $pdo->prepare('UPDATE users SET currency = :currency, symbol = :symbol WHERE id = :user_id');
        
        // Bind parameters without any checks, forcefully upload the symbol and other data
        $updateStmt->bindParam(':currency', $currency);
        $updateStmt->bindParam(':symbol', $symbol, PDO::PARAM_STR); // Ensure it's treated as a string
        $updateStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);

        // Execute the statement
        $result = $updateStmt->execute();

        // Check if the update was successful
        if ($result) {
            echo "Forceful update successful for user ID: " . $userId . "<br>";
            header('Location: ../users'); // Redirect to ../users
            exit; // Ensure the script stops after the redirect
        } else {
            // Error during execution
            echo "Forceful update failed: " . implode(' ', $updateStmt->errorInfo()) . "<br>";
            // Optionally, log the error
            error_log("Forceful update failed: " . implode(' ', $updateStmt->errorInfo()));
        }

    } catch (PDOException $e) {
        // If there is a database error, display the error message
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
        // Log the error
        error_log("PDOException: " . $e->getMessage());
    }
}
?>
