<?php
session_start();
require 'config.db.php';

$response = ['success' => false];

if (isset($_POST['account_number'])) {
    // Fetch the user ID based on the account number
    $stmt = $pdo->prepare('SELECT id FROM users WHERE account_number = ?');
    $stmt->execute([$_POST['account_number']]);
    $user = $stmt->fetch();

    if ($user) {
        $userId = $user['id'];

        try {
            // Start a transaction
            $pdo->beginTransaction();

            // Delete transactions where receiver_id matches
            $stmt = $pdo->prepare('DELETE FROM transactions WHERE receiver_id = ?');
            $stmt->execute([$userId]);

            // Delete transactions where sender_id matches
            $stmt = $pdo->prepare('DELETE FROM transactions WHERE sender_id = ?');
            $stmt->execute([$userId]);

            // Delete messages where user_id matches
            $stmt = $pdo->prepare('DELETE FROM messages WHERE user_id = ?');
            $stmt->execute([$userId]);

            // Now delete the user
            $stmt = $pdo->prepare('DELETE FROM users WHERE account_number = ?');
            if ($stmt->execute([$_POST['account_number']])) {
                $response['success'] = true;
            }

            // Commit the transaction
            $pdo->commit();
        } catch (Exception $e) {
            // Roll back on failure
            $pdo->rollBack();
            error_log($e->getMessage());
        }
    }
}

echo json_encode($response);
?>
