<?php
session_start();
require 'config.db.php';

$response = ['success' => false, 'user_id' => null, 'amount' => null];

if (isset($_POST['account_number']) && isset($_POST['amount'])) {
    $accountNumber = $_POST['account_number'];
    $amount = $_POST['amount'];

    // Update the user's balance
    $stmt = $pdo->prepare('UPDATE users SET balance = balance + ? WHERE account_number = ?');
    if ($stmt->execute([$amount, $accountNumber])) {
        // Get the user's ID
        $userIdStmt = $pdo->prepare('SELECT id FROM users WHERE account_number = ?');
        $userIdStmt->execute([$accountNumber]);
        $userId = $userIdStmt->fetchColumn();

        if ($userId) {
            // Save the transaction details to the transactions table
            $transactionStmt = $pdo->prepare('INSERT INTO transactions (sender_id, receiver_id, amount, description, transaction_type, created_at) VALUES (?, ?, ?, ?, ?, NOW())');
            if ($transactionStmt->execute([$userId, $userId, $amount, 'Account Funding', 'Account Fund'])) {
                $response['success'] = true;
                $response['user_id'] = $userId;
                $response['amount'] = $amount;
            }
        }
    }
}

echo json_encode($response);
?>
