<?php
require 'config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bank_name = $_POST['bank_name'];
    $swift_code = $_POST['swift_code'];
    $beneficiary_account_name = $_POST['beneficiary_account_name'];
    $beneficiary_account_number = $_POST['beneficiary_account_number'];
    $routing_number = $_POST['routing_number'];

    $stmt = $pdo->prepare("
        INSERT INTO bank_details (bank_name, swift_code, beneficiary_account_name, beneficiary_account_number, routing_number)
        VALUES (:bank_name, :swift_code, :beneficiary_account_name, :beneficiary_account_number, :routing_number)
    ");
    $stmt->execute([
        ':bank_name' => $bank_name,
        ':swift_code' => $swift_code,
        ':beneficiary_account_name' => $beneficiary_account_name,
        ':beneficiary_account_number' => $beneficiary_account_number,
        ':routing_number' => $routing_number
    ]);

    header('Location: ../dashboard.php');
    exit();
} else {
    header('Location: ../dashboard.php');
    exit();
}
?>
