<?php
require 'config.db.php';

$search = $_GET['q'] ?? '';

$stmt = $pdo->prepare('SELECT id, full_name, balance, account_number, card, email FROM users WHERE full_name LIKE ?');
$stmt->execute(['%' . $search . '%']);
$users = $stmt->fetchAll();

foreach ($users as $user) {
    echo '<div class="col-md-4">';
    echo '<div class="user-card">';
    echo '<h5>' . htmlspecialchars($user['full_name']) . '</h5>';
    echo '<div class="user-info">';
    echo '<p><strong>Account Number:</strong> ' . htmlspecialchars($user['account_number']) . '</p>';
    echo '<p><strong>Balance:</strong> $' . htmlspecialchars($user['balance']) . '</p>';
    echo '<p>';
    echo '<span class="status-indicator ' . ($user['card'] == 1 ? 'green' : 'red') . '"></span>';
    echo '<strong>Card Status:</strong> ' . ($user['card'] == 1 ? 'Active' : 'Inactive') . '</p>';
    echo '</div>';
    echo '<div class="manage-actions">';
    echo '<button class="btn btn-danger btn-sm delete-btn" data-account="' . $user['account_number'] . '">Delete</button>';
    echo '<button class="btn btn-warning btn-sm freeze-btn" data-account="' . $user['account_number'] . '">Freeze</button>';
    echo '<a href="mail.php?id=' . $user['id'] . '" class="btn btn-primary btn-sm">E-mail</a>';
    echo '</div></div></div>';
}
?>
