<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'server/config.db.php'; // Ensure database connection is included

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_POST['user_id'];
    $action = $_POST['action'];

    try {
        // Check if the user record exists
        $query = "SELECT id FROM users WHERE id = :user_id";
        $stmt = $pdo->prepare($query);
        $stmt->execute([':user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            echo json_encode(['success' => false, 'message' => 'User not found']);
            exit();
        }

        // Implement service fee column changes based on action
        if ($action === 'enable') {
            $query = "UPDATE users SET service_fee = 1 WHERE id = :user_id";
            $stmt = $pdo->prepare($query);
            $stmt->execute([':user_id' => $userId]);

            echo json_encode(['success' => true, 'message' => 'Service fee enabled']);
        } elseif ($action === 'disable') {
            $query = "UPDATE users SET service_fee = 0 WHERE id = :user_id";
            $stmt = $pdo->prepare($query);
            $stmt->execute([':user_id' => $userId]);

            echo json_encode(['success' => true, 'message' => 'Service fee disabled']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
