<?php
// Enable error reporting for debugging (should be disabled in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'server/config.db.php';
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Prepare the email template
function getEmailBody($full_name, $message) {
    return '
    <html>
    <head>
        <style>
            body {
                font-family: Arial, sans-serif;
                color: #333;
                line-height: 1.6;
            }
            .container {
                width: 100%;
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
                background: #f4f4f4;
                border: 1px solid #ddd;
                border-radius: 5px;
            }
            .header {
                text-align: center;
                padding-bottom: 20px;
            }
            .header img {
                width: 150px;
            }
            .content {
                padding: 20px;
                background: #fff;
                border-radius: 5px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .content h2 {
                color: #0056b3;
            }
            .footer {
                text-align: center;
                padding-top: 20px;
                font-size: 0.9em;
                color: #777;
            }
            .footer a {
                color: #0056b3;
                text-decoration: none;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <img src="https://west-libertygroup.com/superadmin/card.png" alt="West Liberty Logo">
            </div>
            <div class="content">
                <h2>Hello ' . htmlspecialchars($full_name) . ',</h2>
                <p>' . nl2br(htmlspecialchars($message)) . '</p>
            </div>
            <div class="footer">
                <p>&copy; ' . date("Y") . 'BLX GROWTH. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>';
}

// Collect form data
$recipientType = $_POST['recipient_type'];
$subject = $_POST['subject'];
$message = $_POST['message'];
$adminName = $_SESSION['username']; // Assuming the admin's name is stored in session

// Create a new PHPMailer instance
$mail = new PHPMailer(true);

try {
    // Server settings
    $mail->isSMTP();
    $mail->Host = 'mail.blxgrowth.online'; // Set the SMTP server to send through
    $mail->SMTPAuth = true;
    $mail->Username = 'no-reply@blxgrowth.online'; // SMTP username
    $mail->Password = 'whodeybreathe'; // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Use SMTPS for port 465
$mail->Port = 465; // SSL port


    // Check recipient type
    if ($recipientType === 'single') {
        // Single user
        $recipientEmail = $_POST['recipient_email'];
        $recipientName = $_POST['recipient_name'];

        // Validate recipient email
        if (empty($recipientEmail) || !filter_var($recipientEmail, FILTER_VALIDATE_EMAIL)) {
            echo "Invalid recipient email address.";
            exit;
        }

        // Send email to the single recipient
        $mail->setFrom('no-reply@blxgrowth.online', 'BLX Growth Online Support');
        $mail->addAddress($recipientEmail, $recipientName);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = getEmailBody($recipientName, $message);
        $mail->AltBody = strip_tags(getEmailBody($recipientName, $message)); // Corrected function call

        $mail->send();

        // Insert into email_sent table
        $stmt = $pdo->prepare("INSERT INTO email_sent (admin_name, recipient_email, subject, message) VALUES (?, ?, ?, ?)");
        $stmt->execute([$adminName, $recipientEmail, $subject, $message]);
    } elseif ($recipientType === 'all') {
        // All users
        $stmt = $pdo->query('SELECT email, full_name FROM users');
        $allUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($allUsers as $user) {
            $recipientEmail = $user['email'];
            $recipientName = $user['full_name'];

            // Validate each email
            if (filter_var($recipientEmail, FILTER_VALIDATE_EMAIL)) {
                // Send email to each recipient
                $mail->setFrom('no-reply@blxgrowth.online', 'BLX Growth Online Support');
                $mail->addAddress($recipientEmail, $recipientName);

                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body    = getEmailBody($recipientName, $message);
                $mail->AltBody = strip_tags(getEmailBody($recipientName, $message)); // Corrected function call

                $mail->send();

                // Clear all recipients for the next iteration
                $mail->clearAddresses();

                // Insert into email_sent table
                $stmt = $pdo->prepare("INSERT INTO email_sent (admin_name, recipient_email, subject, message) VALUES (?, ?, ?, ?)");
                $stmt->execute([$adminName, $recipientEmail, $subject, $message]);
            }
        }

        // Update email count
        $totalEmailsSent = count($allUsers);
        $stmt = $pdo->prepare("INSERT INTO admin_email_count (admin_name, total_emails_sent) VALUES (?, ?)
                               ON DUPLICATE KEY UPDATE total_emails_sent = total_emails_sent + VALUES(total_emails_sent)");
        $stmt->execute([$adminName, $totalEmailsSent]);
    }

    // Redirect after a delay
    echo '<!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Email Sent</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
        <style>
            .container {
                max-width: 600px;
                margin-top: 100px;
                text-align: center;
            }
            .spinner-border {
                width: 3rem;
                height: 3rem;
                border-width: 0.5em;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="alert alert-success" role="alert">
                <h4 class="alert-heading">Success!</h4>
                <p>Your email has been sent!</p>
                <hr>
                <p class="mb-0">Please wait while you are being redirected...</p>
                <div class="spinner-border" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>
        <script>
            setTimeout(function() {
                window.location.href = "dashboard.php";
            }, 3000); // Redirect after 3 seconds
        </script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    </body>
    </html>';
} catch (Exception $e) {
    echo 'Email could not be sent. Mailer Error: ', $mail->ErrorInfo;
}
?>
