<?php
require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['transaction_id'], $data['new_date'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit();
}

$transactionId = (int)$data['transaction_id'];
$newDate = $data['new_date'];

// Validate date format
if (!strtotime($newDate)) {
    echo json_encode(['success' => false, 'message' => 'Invalid date format']);
    exit();
}

$stmt = $pdo->prepare("UPDATE transactions SET created_at = :new_date WHERE id = :transaction_id");
$result = $stmt->execute(['new_date' => $newDate, 'transaction_id' => $transactionId]);

if ($result) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update transaction date']);
}
?>
