<?php
require 'server/config.db.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ensure these are received as POST parameters
    $account_number = $_POST['account_number'];
    $vat_status = $_POST['vat'];

    // Validate data
    if (empty($account_number) || !in_array($vat_status, [0, 1])) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input']);
        exit;
    }

    // Update the VAT status in the database
    $sql = "UPDATE users SET vat = ? WHERE account_number = ?";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute([$vat_status, $account_number])) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update VAT status']);
    }
}
?>
