<?php
require 'server/config.db.php';
session_start();

if (!isset($_SESSION['username'])) {
    header('Location: login.php');
    exit();
}

// Handle user deletion
if (isset($_GET['delete_user_id'])) {
    $delete_user_id = intval($_GET['delete_user_id']);

    try {
        $deleteQuery = "DELETE FROM users WHERE id = :user_id";
        $deleteStmt = $pdo->prepare($deleteQuery);
        $deleteStmt->bindParam(':user_id', $delete_user_id, PDO::PARAM_INT);
        $deleteStmt->execute();

        // Redirect to the same page to avoid re-deletion on refresh
        header("Location: users.php");
        exit();
    } catch (PDOException $e) {
        echo "Failed to delete user: " . $e->getMessage();
    }
}
// Fetch users from the database
try {
    $fetchQuery = "SELECT * FROM users";
    $fetchStmt = $pdo->prepare($fetchQuery);
    $fetchStmt->execute();
    $users = $fetchStmt->fetchAll(PDO::FETCH_ASSOC); // Fetch all users
} catch (PDOException $e) {
    echo "Failed to fetch users: " . $e->getMessage();
    $users = [];
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Users</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
</head>
<body>
    <?php require 'server/active-check.php' ?>
    <?php require 'server/nav.php'; ?>
    
    <!-- Sidebar trigger button for mobile -->
    <button class="btn btn-primary sidebar-toggle-btn d-md-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar -->
    <?php require 'server/sidebar.php'; ?>

    <div class="container-fluid mt-5">
    <h2 class="mb-4">Users</h2>

    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Full Name</th>
                    <th>Balance</th>
                    <th>PIN</th>
                    <th>Card Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($users)): ?>
                    <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['id']); ?></td>
                            <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                            <td><?php echo htmlspecialchars($user['balance']); ?></td>
                            <td><?php echo htmlspecialchars($user['pin']); ?></td>
                            <td>
                                <?php if ($user['card'] == 1): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">No Card</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <!-- Delete Button -->
                                <a href="view_users.php?delete_user_id=<?php echo $user['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this user?');">
                                    <i class="fas fa-trash-alt"></i> Delete
                                </a>

                                <!-- Change Currency Button -->
                                <button class="btn btn-warning btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#currencyDropdown-<?php echo $user['id']; ?>" aria-expanded="false" aria-controls="currencyDropdown-<?php echo $user['id']; ?>">
                                    <i class="fas fa-exchange-alt"></i> Change Currency
                                </button>
                                
                                <form method="POST" action="service_fee.php" onsubmit="return confirm('Are you sure you want to continue this process?');">
    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
    <input type="hidden" name="action" value="enable"> <!-- Change action dynamically if needed -->
    <button type="submit" class="btn btn-success btn-sm">
        <i class="fas fa-dollar-alt"></i> Toggle Service Fee
    </button>
</form>



     <!-- Currency Dropdown -->
<div class="collapse mt-2" id="currencyDropdown-<?php echo $user['id']; ?>">
  <form action="server/change_currency_user.php" method="POST">
    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
    <input type="hidden" name="symbol" id="symbolInput-<?php echo $user['id']; ?>" value="">
    
    <div class="mb-2">
        <label for="currencySelect-<?php echo $user['id']; ?>">Choose Currency:</label>
        <select class="form-select form-select-sm" name="currency" id="currencySelect-<?php echo $user['id']; ?>" required onchange="updateSymbol(<?php echo $user['id']; ?>)">
            <option value="">-- Select Currency --</option>
            <option value="AED" data-symbol="د.إ">United Arab Emirates Dirham (AED)</option>
            <option value="AFN" data-symbol="؋">Afghan Afghani (AFN)</option>
            <option value="ALL" data-symbol="L">Albanian Lek (ALL)</option>
            <option value="AMD" data-symbol="֏">Armenian Dram (AMD)</option>
            <option value="ANG" data-symbol="ƒ">Netherlands Antillean Guilder (ANG)</option>
            <option value="AOA" data-symbol="Kz">Angolan Kwanza (AOA)</option>
            <option value="ARS" data-symbol="$">Argentine Peso (ARS)</option>
            <option value="AUD" data-symbol="$">Australian Dollar (AUD)</option>
            <option value="AWG" data-symbol="ƒ">Aruban Florin (AWG)</option>
            <option value="AZN" data-symbol="₼">Azerbaijani Manat (AZN)</option>
            <option value="BAM" data-symbol="KM">Bosnia-Herzegovina Convertible Mark (BAM)</option>
            <option value="BBD" data-symbol="$">Barbadian Dollar (BBD)</option>
            <option value="BDT" data-symbol="৳">Bangladeshi Taka (BDT)</option>
            <option value="BGN" data-symbol="лв">Bulgarian Lev (BGN)</option>
            <option value="BHD" data-symbol=".د.ب">Bahraini Dinar (BHD)</option>
            <option value="BIF" data-symbol="FBu">Burundian Franc (BIF)</option>
            <option value="BMD" data-symbol="$">Bermudian Dollar (BMD)</option>
            <option value="BND" data-symbol="$">Brunei Dollar (BND)</option>
            <option value="BOB" data-symbol="Bs.">Bolivian Boliviano (BOB)</option>
            <option value="BRL" data-symbol="R$">Brazilian Real (BRL)</option>
            <option value="BSD" data-symbol="$">Bahamian Dollar (BSD)</option>
            <option value="BTN" data-symbol="Nu.">Bhutanese Ngultrum (BTN)</option>
            <option value="BWP" data-symbol="P">Botswana Pula (BWP)</option>
            <option value="BYN" data-symbol="Br">Belarusian Ruble (BYN)</option>
            <option value="BZD" data-symbol="BZ$">Belize Dollar (BZD)</option>
            <option value="CAD" data-symbol="$">Canadian Dollar (CAD)</option>
            <option value="CDF" data-symbol="FC">Congolese Franc (CDF)</option>
            <option value="CHF" data-symbol="CHF">Swiss Franc (CHF)</option>
            <option value="CLP" data-symbol="$">Chilean Peso (CLP)</option>
            <option value="CNY" data-symbol="¥">Chinese Yuan (CNY)</option>
            <option value="COP" data-symbol="$">Colombian Peso (COP)</option>
            <option value="CRC" data-symbol="₡">Costa Rican Colón (CRC)</option>
            <option value="CUP" data-symbol="$">Cuban Peso (CUP)</option>
            <option value="CVE" data-symbol="$">Cape Verdean Escudo (CVE)</option>
            <option value="CZK" data-symbol="Kč">Czech Koruna (CZK)</option>
            <option value="DJF" data-symbol="Fdj">Djiboutian Franc (DJF)</option>
            <option value="DKK" data-symbol="kr">Danish Krone (DKK)</option>
            <option value="DOP" data-symbol="RD$">Dominican Peso (DOP)</option>
            <option value="DZD" data-symbol="دج">Algerian Dinar (DZD)</option>
            <option value="EGP" data-symbol="£">Egyptian Pound (EGP)</option>
            <option value="ERN" data-symbol="Nkf">Eritrean Nakfa (ERN)</option>
            <option value="ETB" data-symbol="Br">Ethiopian Birr (ETB)</option>
            <option value="EUR" data-symbol="€">Euro (EUR)</option>
            <option value="FJD" data-symbol="$">Fijian Dollar (FJD)</option>
            <option value="FKP" data-symbol="£">Falkland Islands Pound (FKP)</option>
            <option value="FOK" data-symbol="kr">Faroese Króna (FOK)</option>
            <option value="GBP" data-symbol="£">British Pound Sterling (GBP)</option>
            <option value="GEL" data-symbol="₾">Georgian Lari (GEL)</option>
            <option value="GGP" data-symbol="£">Guernsey Pound (GGP)</option>
            <option value="GHS" data-symbol="₵">Ghanaian Cedi (GHS)</option>
            <option value="GIP" data-symbol="£">Gibraltar Pound (GIP)</option>
            <option value="GMD" data-symbol="D">Gambian Dalasi (GMD)</option>
            <option value="GNF" data-symbol="FG">Guinean Franc (GNF)</option>
            <option value="GTQ" data-symbol="Q">Guatemalan Quetzal (GTQ)</option>
            <option value="GYD" data-symbol="$">Guyanese Dollar (GYD)</option>
            <option value="HKD" data-symbol="$">Hong Kong Dollar (HKD)</option>
            <option value="HNL" data-symbol="L">Honduran Lempira (HNL)</option>
            <option value="HRK" data-symbol="kn">Croatian Kuna (HRK)</option>
            <option value="HTG" data-symbol="G">Haitian Gourde (HTG)</option>
            <option value="HUF" data-symbol="Ft">Hungarian Forint (HUF)</option>
            <option value="IDR" data-symbol="Rp">Indonesian Rupiah (IDR)</option>
            <option value="ILS" data-symbol="₪">Israeli New Shekel (ILS)</option>
            <option value="IMP" data-symbol="£">Isle of Man Pound (IMP)</option>
            <option value="INR" data-symbol="₹">Indian Rupee (INR)</option>
            <option value="IQD" data-symbol="ع.د">Iraqi Dinar (IQD)</option>
            <option value="IRR" data-symbol="﷼">Iranian Rial (IRR)</option>
            <option value="ISK" data-symbol="kr">Icelandic Króna (ISK)</option>
            <option value="JMD" data-symbol="$">Jamaican Dollar (JMD)</option>
            <option value="JOD" data-symbol="د.ا">Jordanian Dinar (JOD)</option>
            <option value="JPY" data-symbol="¥">Japanese Yen (JPY)</option>
            <option value="KES" data-symbol="KSh">Kenyan Shilling (KES)</option>
            <option value="KGS" data-symbol="лв">Kyrgyzstani Som (KGS)</option>
            <option value="KHR" data-symbol="៛">Cambodian Riel (KHR)</option>
            <option value="KID" data-symbol="$">Kiribati Dollar (KID)</option>
            <option value="KMF" data-symbol="CF">Comorian Franc (KMF)</option>
            <option value="KRW" data-symbol="₩">South Korean Won (KRW)</option>
            <option value="KWD" data-symbol="د.ك">Kuwaiti Dinar (KWD)</option>
            <option value="KYD" data-symbol="$">Cayman Islands Dollar (KYD)</option>
            <option value="KZT" data-symbol="〒">Kazakhstani Tenge (KZT)</option>
            <option value="LAK" data-symbol="₭">Lao Kip (LAK)</option>
            <option value="LBP" data-symbol="ل.ل">Lebanese Pound (LBP)</option>
            <option value="LKR" data-symbol="Rs">Sri Lankan Rupee (LKR)</option>
            <option value="LRD" data-symbol="$">Liberian Dollar (LRD)</option>
            <option value="LSL" data-symbol="M">Lesotho Loti (LSL)</option>
            <option value="LYD" data-symbol="د.ل">Libyan Dinar (LYD)</option>
            <option value="MAD" data-symbol="د.م.">Moroccan Dirham (MAD)</option>
    <option value="MDL" data-symbol="L">Moldovan Leu (MDL)</option>
    <option value="MGA" data-symbol="Ar">Malagasy Ariary (MGA)</option>
    <option value="MKD" data-symbol="ден">Macedonian Denar (MKD)</option>
    <option value="MMK" data-symbol="K">Myanmar Kyat (MMK)</option>
    <option value="MNT" data-symbol="₮">Mongolian Tögrög (MNT)</option>
    <option value="MOP" data-symbol="MOP$">Macanese Pataca (MOP)</option>
    <option value="MRU" data-symbol="UM">Mauritanian Ouguiya (MRU)</option>
    <option value="MUR" data-symbol="₨">Mauritian Rupee (MUR)</option>
    <option value="MVR" data-symbol="Rf">Maldivian Rufiyaa (MVR)</option>
    <option value="MWK" data-symbol="MK">Malawian Kwacha (MWK)</option>
    <option value="MXN" data-symbol="$">Mexican Peso (MXN)</option>
    <option value="MYR" data-symbol="RM">Malaysian Ringgit (MYR)</option>
    <option value="MZN" data-symbol="MT">Mozambican Metical (MZN)</option>
    <option value="NAD" data-symbol="$">Namibian Dollar (NAD)</option>
    <option value="NGN" data-symbol="₦">Nigerian Naira (NGN)</option>
    <option value="NIO" data-symbol="C$">Nicaraguan Córdoba (NIO)</option>
    <option value="NOK" data-symbol="kr">Norwegian Krone (NOK)</option>
    <option value="NPR" data-symbol="₨">Nepalese Rupee (NPR)</option>
    <option value="NZD" data-symbol="$">New Zealand Dollar (NZD)</option>
    <option value="OMR" data-symbol="ر.ع.">Omani Rial (OMR)</option>
    <option value="PAB" data-symbol="B/.">Panamanian Balboa (PAB)</option>
    <option value="PEN" data-symbol="S/">Peruvian Sol (PEN)</option>
    <option value="PGK" data-symbol="K">Papua New Guinean Kina (PGK)</option>
    <option value="PHP" data-symbol="₱">Philippine Peso (PHP)</option>
    <option value="PKR" data-symbol="₨">Pakistani Rupee (PKR)</option>
    <option value="PLN" data-symbol="zł">Polish Złoty (PLN)</option>
    <option value="PYG" data-symbol="₲">Paraguayan Guarani (PYG)</option>
    <option value="QAR" data-symbol="ر.ق">Qatari Rial (QAR)</option>
    <option value="RON" data-symbol="lei">Romanian Leu (RON)</option>
    <option value="RSD" data-symbol="дин.">Serbian Dinar (RSD)</option>
    <option value="RUB" data-symbol="₽">Russian Ruble (RUB)</option>
    <option value="RWF" data-symbol="FRw">Rwandan Franc (RWF)</option>
    <option value="SAR" data-symbol="ر.س">Saudi Riyal (SAR)</option>
    <option value="SBD" data-symbol="$">Solomon Islands Dollar (SBD)</option>
    <option value="SCR" data-symbol="₨">Seychellois Rupee (SCR)</option>
    <option value="SDG" data-symbol="ج.س.">Sudanese Pound (SDG)</option>
    <option value="SEK" data-symbol="kr">Swedish Krona (SEK)</option>
    <option value="SGD" data-symbol="$">Singapore Dollar (SGD)</option>
    <option value="SHP" data-symbol="£">Saint Helena Pound (SHP)</option>
    <option value="SLL" data-symbol="Le">Sierra Leonean Leone (SLL)</option>
    <option value="SOS" data-symbol="Sh">Somali Shilling (SOS)</option>
    <option value="SRD" data-symbol="$">Surinamese Dollar (SRD)</option>
    <option value="SSP" data-symbol="£">South Sudanese Pound (SSP)</option>
    <option value="STN" data-symbol="Db">São Tomé and Príncipe Dobra (STN)</option>
    <option value="SYP" data-symbol="£">Syrian Pound (SYP)</option>
    <option value="SZL" data-symbol="L">Eswatini Lilangeni (SZL)</option>
    <option value="THB" data-symbol="฿">Thai Baht (THB)</option>
    <option value="TJS" data-symbol="ЅМ">Tajikistani Somoni (TJS)</option>
    <option value="TMT" data-symbol="T">Turkmenistani Manat (TMT)</option>
    <option value="TND" data-symbol="د.ت">Tunisian Dinar (TND)</option>
    <option value="TOP" data-symbol="T$">Tongan Paʻanga (TOP)</option>
    <option value="TRY" data-symbol="₺">Turkish Lira (TRY)</option>
    <option value="TTD" data-symbol="TT$">Trinidad and Tobago Dollar (TTD)</option>
    <option value="TVD" data-symbol="$">Tuvaluan Dollar (TVD)</option>
    <option value="TWD" data-symbol="NT$">New Taiwan Dollar (TWD)</option>
    <option value="TZS" data-symbol="Sh">Tanzanian Shilling (TZS)</option>
    <option value="UAH" data-symbol="₴">Ukrainian Hryvnia (UAH)</option>
    <option value="UGX" data-symbol="Sh">Ugandan Shilling (UGX)</option>
    <option value="USD" data-symbol="$">United States Dollar (USD)</option>
    <option value="UYU" data-symbol="$U">Uruguayan Peso (UYU)</option>
    <option value="UZS" data-symbol="лв">Uzbekistani Soʻm (UZS)</option>
    <option value="VES" data-symbol="Bs.S">Venezuelan Bolívar (VES)</option>
    <option value="VND" data-symbol="₫">Vietnamese Đồng (VND)</option>
    <option value="VUV" data-symbol="VT">Vanuatu Vatu (VUV)</option>
    <option value="WST" data-symbol="T">Samoan Tālā (WST)</option>
    <option value="XAF" data-symbol="FCFA">Central African CFA Franc (XAF)</option>
    <option value="XCD" data-symbol="$">East Caribbean Dollar (XCD)</option>
    <option value="XOF" data-symbol="CFA">West African CFA Franc (XOF)</option>
    <option value="XPF" data-symbol="₣">CFP Franc (XPF)</option>
    <option value="YER" data-symbol="﷼">Yemeni Rial (YER)</option>
    <option value="ZAR" data-symbol="R">South African Rand (ZAR)</option>
    <option value="ZMW" data-symbol="ZK">Zambian Kwacha (ZMW)</option>
    <option value="ZWL" data-symbol="$">Zimbabwean Dollar (ZWL)</option>
        </select>
    </div>

    <div class="text-center">
        <button type="submit" class="btn btn-primary">Save Currency</button>
    </div>
  </form>
</div>

                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6">No users found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- JavaScript -->
<script>
function updateSymbol(userId) {
    var select = document.getElementById('currencySelect-' + userId);
    var symbolInput = document.getElementById('symbolInput-' + userId);
    var selectedOption = select.options[select.selectedIndex];
    var symbol = selectedOption.getAttribute('data-symbol');
    symbolInput.value = symbol;
}
</script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</body>
</html>
