<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';
?>

<!DOCTYPE html>
<html lang="en-US" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="../images/favicon.jpg">
    <!-- Page Title  -->
    <title>Withdrawal</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
    <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
    <link href="../css/toastr.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
        .goog-te-gadget-simple {
            border: none;
        }
        .goog-te-gadget-simple a {
            color: #000;
        }
        .btn-primary {
            background-color: #033d75;
        }
        .btn-secondary {
            background-color: #d13636;
        }
        .btn-secondary:hover { opacity: 0.6; }
        .btn-primary:hover { opacity: 0.6; }
        
        .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
    </style>
</head>
<body class="nk-body npc-crypto bg-white has-sidebar">
    
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo">
                                    <img class="logo-dark logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->
                <!-- content @s -->
                <div class="nk-content nk-content-fluid">
                    <div class="container-xl wide-lg">
                        

                    </div>
            <!-- wrap @e -->
        </div>
        <!-- main @e -->
    </div>
    <!-- app-root @e -->
    <!-- JavaScript -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://swifttess.com/assets/js/bundle.js"></script>
    <script src="https://swifttess.com/assets/js/scripts.js"></script>
    <script src="https://swifttess.com/assets/js/charts/chart-crypto.js"></script>
    <script src="https://swifttess.com/assets/js/sweetalert.js"></script>
   <script src="https://swifttess.com/assets/js/jquery.min.js"></script>
   <script src="../assets/js/custom.js"></script>
   <script src="https://swifttess.com/js/toastr.js"></script>

<!-- CSS -->
<style>
    .chat-button {
        position: fixed;
        bottom: 20px;
        right: 20px;
        background-color: #033d75;
        color: white;
        padding: 15px;
        border-radius: 50%;
        cursor: pointer;
        z-index: 1000;
        display: flex;
        justify-content: center;
        align-items: center;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .chat-button i {
        font-size: 24px;
    }
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.8); /* Darker background */
    }
    .modal-content {
        display: flex;
        flex-direction: column;
        height: 100%;
        background-color: white;
        margin: 0; /* No margin to cover the full screen */
        padding: 0; /* Remove padding for header adjustment */
        border: none;
        width: 100%;
        height: 100%;
        max-width: none; /* Override max-width */
        max-height: none; /* Override max-height */
        border-radius: 0; /* Remove border radius for full screen */
    }
    .modal-header {
        display: flex;
        flex-direction: column; /* Stack items vertically */
        align-items: center;
        padding: 15px;
        background-color: #332120; /* Gray background */
        border-bottom: 1px solid #ddd;
        position: relative;
        color: white;
    }
    .modal-header b {
        font-size: 18px;
    }
    .modal-header p {
        font-size: 14px;
        color: rgba(255, 255, 255, 0.7); /* Faded white */
    }
    .header-users {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 20px;
        margin-top: 10px;
    }
    .user-icon {
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    .user-icon i {
        font-size: 36px;
        color: #333;
        text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3); /* Shadow effect */
    }
    .user-name {
        margin: 5px 0;
        font-size: 14px;
        color: white;
        font-weight: bold; /* Bold user names */
    }
    .status {
        font-size: 12px;
        color: rgba(255, 255, 255, 0.7); /* Faded white */
    }
    .user {
        color: #007bff; /* Blue for user */
    }
    .admin {
        color: green; /* Green for admin */
    }
    
    .message-area {
        flex: 1;
        overflow-y: auto;
        padding: 15px;
        background-color: #f7f7f7;
    }
    .message {
        max-width: 80%;
        padding: 10px 15px;
        margin: 10px 0;
        border-radius: 20px;
        font-size: 14px;
        line-height: 1.0;
        clear: both;
    }
    .admin-message {
        background-color: #033d75;
        color: white;
        float: left; /* Align admin messages to the left */
    }
    .user-message {
        background-color: #007bff;
        color: white;
        float: right; /* Align user messages to the right */
    }
    .message-bar {
        display: flex;
        align-items: center;
        padding: 10px;
        border-top: 1px solid #ddd;
        background-color: white;
    }
    .message-bar button {
        background: transparent;
        border: none;
        cursor: pointer;
    }
    .message-bar button:focus {
        outline: none;
    }
    .message-bar .chat-button-icon {
        font-size: 20px;
        color: #333;
    }
    .message-bar textarea {
        flex: 1;
        margin: 0 10px;
        padding: 10px;
        border-radius: 20px;
        border: 1px solid #ddd;
        resize: none;
        height: 40px; 
        font-size: 14px;
    }
    .message-bar .btn-primary {
        background-color: #033d75;
        border: none;
        color: white;
        padding: 10px 15px;
        border-radius: 20px;
        cursor: pointer;
        font-size: 14px;
    }
    .message-bar .btn-primary:hover {
        background-color: #022a56;
    }
    
    .chat-notification {
    position: absolute;
    top: -5px;
    right: -5px;
    background-color: red;
    color: white;
    padding: 2px 6px;
    border-radius: 50%;
    font-size: 12px;
    font-weight: bold;
}

.callout-message {
    position: absolute;
    bottom: 60px;
    right: 0;
    background-color: #033d75;
    color: white;
    padding: 10px;
    border-radius: 10px;
    font-size: 12px;
    display: none; /* Initially hidden */
    white-space: nowrap; /* Prevent text from wrapping */
}

.chat-button:hover .callout-message {
    display: block; /* Show the callout message on hover */
}

</style>
                    </div>
                </div>
                <!-- content @e -->
                <?php require 'server/footer.php' ?>
            </div>
            <!-- wrap @e -->
        </div>
        <!-- main @e -->
    </div>

</body>
</html>
