create_pin.php
<?php
session_start();
require 'server/config.db.php';

$data = json_decode(file_get_contents('php://input'), true);
$pin = $data['pin'] ?? '';

if (empty($pin)) {
    echo json_encode(['success' => false, 'error' => 'PIN is required.']);
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("UPDATE users SET pin = ? WHERE id = ?");
$stmt->execute([$pin, $user_id]);

if ($stmt->rowCount()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Error setting PIN. Please try again.']);
}
?>
