<?php
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';


// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
?>
    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="./logo.png">
    <!-- Page Title  -->
    <title>SwiftHeart Virtual Card</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
.goog-te-gadget-simple {
border:none;
}
.goog-te-gadget-simple a {
color:#000;
}
</style>
<style type="text/css">
    .btn-primary{
        background-color: #033d75;
    }
    .btn-secondary{
        background-color: #d13636;
    }
    .btn-secondary:hover{opacity: 0.6;}
    .btn-primary:hover{opacity: 0.6;}
    
    .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
  
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="./logo.png" srcset="./logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="./logo.png" srcset="../logo.png" alt="logo-dark">
  
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->                <!-- content @s -->
                <!-- main header @e -->                
                <div class="nk-content nk-content-fluid">
                <div id="customerChat" class="chat-container">
    <div class="chat-header">
        <b class="user-name">Customer Service</b>
        <p id="sessionUserStatus">Active Recently</p>
    </div>

    <div id="messageArea" class="message-area">
        <!-- Default admin message -->
        <div class="message admin-message">
            <p>Good Day! If you need any assistance, we are always at your service. Thanks</p>
        </div>
    </div>

    <form id="messageForm" class="message-input-bar">
        <button type="button" id="attachButton" class="chat-button-icon">
            <i class="fas fa-paperclip"></i>
        </button>
        <textarea id="chatMessage" name="chat_message" placeholder="Type your message..."></textarea>
        <button type="submit" class="send-button">
            <i class="fas fa-paper-plane"></i>
        </button>
    </form>
</div>
<style>
    /* Center the chat container */
.chat-container {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 350px;
    max-width: 95%;
    height: 500px;
    border: 1px solid #ddd;
    border-radius: 10px;
    display: flex;
    flex-direction: column;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    background: #fff;
    overflow: hidden;
    z-index: 1000;
}

/* Chat header */
.chat-header {
    background: #033d75;
    color: #fff;
    padding: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
    font-size: 16px;
}

/* Message area */
.message-area {
    flex: 1;
    padding: 10px;
    overflow-y: auto;
    background: #f9f9f9;
}

.message {
    margin-bottom: 10px;
    max-width: 80%;
    padding: 10px;
    border-radius: 10px;
}

.user-message {
    background: #d9fdd3;
    align-self: flex-end;
}

.admin-message {
    background: #e0e0e0;
    align-self: flex-start;
}

/* Input bar */
.message-input-bar {
    display: flex;
    align-items: center;
    padding: 10px;
    border-top: 1px solid #ddd;
    background: #fff;
}

.chat-button-icon {
    border: none;
    background: none;
    margin-right: 5px;
    font-size: 18px;
    color: #666;
    cursor: pointer;
}

#chatMessage {
    flex: 1;
    border: 1px solid #ddd;
    border-radius: 20px;
    padding: 10px;
    outline: none;
    resize: none;
    font-size: 14px;
}

.send-button {
    border: none;
    background: #033d75;
    color: #fff;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-left: 5px;
    font-size: 18px;
    cursor: pointer;
}

/* Mobile responsiveness */
@media (max-width: 480px) {
    .chat-container {
        width: 90%;
        height: 400px;
    }

    .chat-header {
        font-size: 14px;
    }

    .message-input-bar {
        padding: 5px;
    }

    #chatMessage {
        font-size: 12px;
        padding: 8px;
    }

    .send-button {
        width: 35px;
        height: 35px;
        font-size: 16px;
    }
}

</style>

<script>
    document.addEventListener('DOMContentLoaded', function () {
    // Auto-scroll to the bottom of the chat area
    var messageArea = document.getElementById('messageArea');
    messageArea.scrollTop = messageArea.scrollHeight;

    // Fetch the user's name from the session using PHP
    var sessionUserName = "<?php echo $_SESSION['user_name']; ?>";
    document.getElementById('sessionUserName').textContent = sessionUserName;

    // Fetch previous messages
    fetchMessages();

    // Handle form submission
    document.getElementById('messageForm').addEventListener('submit', function (event) {
        event.preventDefault();
        var message = document.getElementById('chatMessage').value;

        // Check if the message is empty
        if (message.trim() === '') {
            alert('Message cannot be empty.');
            return;
        }

        // Send the message via AJAX
        $.ajax({
            url: 'server/save_message.php',
            type: 'POST',
            data: { chat_message: message },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    // Append the user's message
                    appendMessage('user', message);

                    // Clear the input field
                    document.getElementById('chatMessage').value = '';

                    // Remove the default admin message if it exists
                    var adminMessage = document.querySelector('.admin-message');
                    if (adminMessage) {
                        adminMessage.remove();
                    }
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function () {
                alert('Failed to send the message. Please try again.');
            }
        });
    });
});

function fetchMessages() {
    $.ajax({
        url: 'server/get_messages.php',
        type: 'GET',
        dataType: 'json',
        success: function (messages) {
            var messageArea = document.getElementById('messageArea');
            messageArea.innerHTML = ''; // Clear existing messages

            messages.forEach(function (message) {
                appendMessage(message.sender, message.content);
            });

            // Scroll to the bottom of the message area
            var messageArea = document.getElementById('messageArea');
            messageArea.scrollTop = messageArea.scrollHeight;
        },
        error: function () {
            alert('Failed to fetch messages. Please refresh the page.');
        }
    });
}

function appendMessage(sender, content) {
    var messageArea = document.getElementById('messageArea');
    var messageDiv = document.createElement('div');
    messageDiv.className = sender === 'admin' ? 'message admin-message' : 'message user-message';
    messageDiv.innerHTML = '<p>' + content + '</p>';
    messageArea.appendChild(messageDiv);

    // Scroll to the bottom of the chat
    messageArea.scrollTop = messageArea.scrollHeight;
}

</script>
</div><!-- .card-inner -->
                                </div><!-- .card -->
                            </div><!-- .nk-block -->
                        </div>
                    </div>
                </div>
                <!-- content @e -->
                <?php require 'server/footer.php' ?> 