<?php
require 'server/config.db.php';

// Fetch user data
$query = "SELECT full_name, email FROM users";
$stmt = $pdo->prepare($query);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Export to CSV
if (isset($_POST['export_csv'])) {
    header("Content-Type: text/csv");
    header("Content-Disposition: attachment; filename=users_data.csv");
    $output = fopen("php://output", "w");
    fputcsv($output, ['Full Name', 'Email']); // Add header row
    foreach ($users as $user) {
        fputcsv($output, $user);
    }
    fclose($output);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Data</title>
</head>
<body>
    <h1>User Data</h1>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>Full Name</th>
                <th>Email</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <form method="post">
        <button type="submit" name="export_csv">Export to CSV</button>
    </form>
</body>
</html>
