<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require 'server/config.db.php';

// Ensure the response is in JSON format
header('Content-Type: application/json');

// Initialize response array
$response = ['status' => 'error', 'banks' => [], 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Read input data
        $data = json_decode(file_get_contents("php://input"));
        $accountNumber = $data->accountNumber ?? '';  // Get the account number from the JSON data

        // Check if account number is provided
        if (!empty($accountNumber)) {
            // Prepare and execute the query to get all unique bank names
            $stmt = $conn->prepare("SELECT DISTINCT bank_name FROM bank_details");
            $stmt->execute();

            // Fetch all unique bank names
            $banks = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (!empty($banks)) {
                // If banks found, add to response
                foreach ($banks as $row) {
                    $response['banks'][] = $row['bank_name'];
                }
                $response['status'] = 'success';
            } else {
                // No banks found in the database
                $response['message'] = 'No bank names found in the database.';
            }
        } else {
            // Missing account number in the request
            $response['message'] = 'Account number is required.';
        }
    } catch (PDOException $e) {
        // Catch any PDO database errors
        $response['message'] = 'Database error: ' . $e->getMessage();
    } catch (Exception $e) {
        // Catch any other errors
        $response['message'] = 'Unexpected error: ' . $e->getMessage();
    }
} else {
    // Invalid request method
    $response['message'] = 'Invalid request method. Only POST is allowed.';
}

// Log the response to the PHP error log (optional for debugging)
error_log(json_encode($response)); 

// Output the response as JSON
echo json_encode($response);
?>
