<?php
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit;
}

$userId = $_SESSION['user_id'];

// Fetch the user balance
$stmt = $pdo->prepare('SELECT balance FROM users WHERE id = :userId');
$stmt->execute(['userId' => $userId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch the currency symbol
$stmt = $pdo->prepare('SELECT symbol FROM settings WHERE id = 1'); // Adjust query as needed
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user && $settings) {
    echo json_encode([
        'success' => true,
        'balance' => $user['balance'],
        'symbol' => $settings['symbol']  // Add the currency symbol to the response
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'User or currency settings not found']);
}
?>
