<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php'; 
require 'server/header.php';

// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$result = mysqli_query($conn, $query);
$settings = mysqli_fetch_assoc($result);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

// Query to get user data (including VAT, currency, symbol, and service fee)
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE id = '$user_id'";
$result = mysqli_query($conn, $query);
$user = mysqli_fetch_assoc($result);

// Get user data from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat'];
$service_fee = $user['service_fee'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>


    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="https://west-libertygroup.com/images/favicon.png">
    <!-- Page Title  -->
    <title>BLX GROWTH DASHBOARD</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
.goog-te-gadget-simple {
border:none;
}
.goog-te-gadget-simple a {
color:#000;
}
</style>
<style type="text/css">
    .btn-primary{
        background-color: #033d75;
    }
    .btn-secondary{
        background-color: #d13636;
    }
    .btn-secondary:hover{opacity: 0.6;}
    .btn-primary:hover{opacity: 0.6;}
    
    .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
    
    <div class="preloader">
        <img src="loader.gif" alt="Loading...">
    </div>
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="https://west-libertygroup.com/images/favicon.png" srcset="https://west-libertygroup.com/images/favicon.png" alt="logo">
                                    <img class="logo-dark logo-img" src="https://west-libertygroup.com/images/favicon.png" srcset="https://west-libertygroup.com/images/favicon.png" alt="logo-dark">
  
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->                <!-- content @s -->
                <div class="nk-content nk-content-fluid">
                    <div class="container-xl wide-lg">
                        <div class="nk-content-body">
                            <div class="nk-block-between-md g-4 card-bordered">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title fw-normal"><?php echo $greeting; ?>,
                                        <?php echo $user['full_name']; ?></h4>
                                        <div class="nk-block-des">
                                            <p>At a glance summary of your account!</p>
                                        </div>
                                    </div><!-- .nk-block-head-content -->
                            </div><!-- .nk-block-head -->
                            <div class="nk-block">
                                <div class="row gy-gs">
                                    <div class="col-lg-6 col-xl-6">
                                        <div class="nk-block">
                                            <div class="nk-block-head-xs">
                                                <div class="nk-block-head-content">
                                                    <h5 class="nk-block-title title">Overview</h5>
                                                </div>
                                            
                                            </div><!-- .nk-block-head -->
                                            <div class="nk-block">
                                                <div class="card card-bordered text-light is-dark h-100">
                                                    <div class="card-inner">
                                                        <div class="nk-wg7">
                                                            <div class="nk-wg7-stats-group">
                                                            	
                                                            <div class="nk-wg7-stats">
    <div class="nk-wg7-title">Available balance</div>
    <div class="amount-container">
    <!-- Balance Display -->
<div id="balance" class="balance">
    <!-- Display the currency symbol separately -->
    <span id="symbol"><?php echo htmlspecialchars($symbol); ?></span>
    
    <!-- Display the balance amount -->
    <span id="balance-amount"><?php echo number_format($userBalance); ?></span>
    
    <!-- Display the currency code separately -->
    <span id="currency"><?php echo htmlspecialchars($currency); ?></span>
</div>

        <div id="hidden-balance" class="hidden-balance">*****</div>
        <i class="fas fa-eye icon-button" onclick="toggleBalance()"></i>
    </div>
    <div class="nk-wg7-title">Account Number</div>
    <div class="account-number-container">
        <span id="account-number"><?php echo $user['account_number']; ?></span>
        <i class="fas fa-copy icon-button" onclick="copyAccountNumber()"></i>
    </div>
    <?php echo $user['full_name']; ?>
</div>

<style>
    #balance {
    font-size: 1.5em; /* Adjust overall balance size */
    display: flex;
    align-items: center; /* Center align items vertically */
}

#symbol {
    margin-right: 5px; /* Add space between symbol and amount */
}

#balance-amount {
    margin-right: 5px; /* Add space between balance and currency code */
}

#currency {
    font-size: 1em; /* Currency code smaller */
}

    /* Flex container for balance and icons */
    .amount-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 10px;
        width: 100%;
    }

    .balance {
        font-size: 24px;
        font-weight: bold;
        flex-grow: 1;
        white-space: nowrap; /* Prevent text wrapping */
    }

    .hidden-balance {
        font-size: 24px;
        font-weight: bold;
        flex-grow: 1;
        white-space: nowrap;
        display: none; /* Initially hidden */
    }

    .account-number-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .account-number {
        font-size: 12px;
        flex-grow: 1;
        white-space: nowrap; /* Prevent text wrapping */
    }

    .icon-button {
        cursor: pointer;
    }

    /* Responsive design for mobile view */
    @media screen and (max-width: 768px) {
        .amount-container, .account-number-container {
            justify-content: space-between;
        }
        .balance, .hidden-balance, .account-number {
            font-size: 18px;
        }
    }
</style>

                                                            
                                                            
                                                                
                                                            </div>
                                                        </div><!-- .nk-wg7 -->
                                                    </div><!-- .card-inner -->
                                                </div><!-- .card -->
                                            </div><!-- .nk-block -->
                                        </div><!-- .nk-block -->
                                    </div><!-- .col -->
                                     <div class="col-lg-6 col-xl-6">
                                         <div id="custom-alert">Account number copied to clipboard</div>
                                    </div><!-- .col -->
                                </div><!-- .row -->
                            </div><!-- .nk-block -->
                            
                            <div class="nk-block-head">
                                <div class="nk-block-head-sub">
                                </div>
                                    <div class="nk-block-head-content">
                                        <ul class="nk-block-tools gx-3">
                                            <li><a href="deposit" class="btn btn-primary"><span>Deposit</span> <em class="fas fa-arrow-long-right"></em></a></li>
                                            <li><a href="transfer" class="btn btn-secondary btn-light text-light"><span>Transfer Fund</span> <em class="fas fa-arrow-long-right d-none d-sm-inline-block"></em></a></li>
                                        </ul>
                                    </div><!-- .nk-block-head-content -->
                                </div><!-- .nk-block-between -->
                            
                             <?php require 'server/transactions.php' ?> 
                                                
                                    
                                
                            <div class="nk-block">
                                <div class="card card-bordered">
                                    <div class="card-inner card-inner-lg">
                                        <div class="align-center flex-wrap flex-md-nowrap g-4">
                                            <div class="nk-block-image w-120px flex-shrink-0">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 118">
                                                    <path d="M8.916,94.745C-.318,79.153-2.164,58.569,2.382,40.578,7.155,21.69,19.045,9.451,35.162,4.32,46.609.676,58.716.331,70.456,1.845,84.683,3.68,99.57,8.694,108.892,21.408c10.03,13.679,12.071,34.71,10.747,52.054-1.173,15.359-7.441,27.489-19.231,34.494-10.689,6.351-22.92,8.733-34.715,10.331-16.181,2.192-34.195-.336-47.6-12.281A47.243,47.243,0,0,1,8.916,94.745Z" transform="translate(0 -1)" fill="#f6faff" />
                                                    <rect x="18" y="32" width="84" height="50" rx="4" ry="4" fill="#fff" />
                                                    <rect x="26" y="44" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                                    <rect x="50" y="44" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                                    <rect x="74" y="44" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                                    <rect x="38" y="60" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                                    <rect x="62" y="60" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                                    <path d="M98,32H22a5.006,5.006,0,0,0-5,5V79a5.006,5.006,0,0,0,5,5H52v8H45a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2H73a2,2,0,0,0,2-2V94a2,2,0,0,0-2-2H66V84H98a5.006,5.006,0,0,0,5-5V37A5.006,5.006,0,0,0,98,32ZM73,94v4H45V94Zm-9-2H54V84H64Zm37-13a3,3,0,0,1-3,3H22a3,3,0,0,1-3-3V37a3,3,0,0,1,3-3H98a3,3,0,0,1,3,3Z" transform="translate(0 -1)" fill="#798bff" />
                                                    <path d="M61.444,41H40.111L33,48.143V19.7A3.632,3.632,0,0,1,36.556,16H61.444A3.632,3.632,0,0,1,65,19.7V37.3A3.632,3.632,0,0,1,61.444,41Z" transform="translate(0 -1)" fill="#6576ff" />
                                                    <path d="M61.444,41H40.111L33,48.143V19.7A3.632,3.632,0,0,1,36.556,16H61.444A3.632,3.632,0,0,1,65,19.7V37.3A3.632,3.632,0,0,1,61.444,41Z" transform="translate(0 -1)" fill="none" stroke="#6576ff" stroke-miterlimit="10" stroke-width="2" />
                                                    <line x1="40" y1="22" x2="57" y2="22" fill="none" stroke="#fffffe" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" />
                                                    <line x1="40" y1="27" x2="57" y2="27" fill="none" stroke="#fffffe" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" />
                                                    <line x1="40" y1="32" x2="50" y2="32" fill="none" stroke="#fffffe" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" />
                                                    <line x1="30.5" y1="87.5" x2="30.5" y2="91.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                                    <line x1="28.5" y1="89.5" x2="32.5" y2="89.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                                    <line x1="79.5" y1="22.5" x2="79.5" y2="26.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                                    <line x1="77.5" y1="24.5" x2="81.5" y2="24.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                                    <circle cx="90.5" cy="97.5" r="3" fill="none" stroke="#9cabff" stroke-miterlimit="10" />
                                                    <circle cx="24" cy="23" r="2.5" fill="none" stroke="#9cabff" stroke-miterlimit="10" /></svg>
                                            </div>
                                            
                                        </div>
                                    </div><!-- .card-inner -->
                                </div><!-- .card -->
                            </div><!-- .nk-block -->
                        </div>
                    </div>
                </div>
                <!-- content @e -->
                <?php require 'server/footer.php' ?>
                <style>
        .nk-wg7-stats {
            display: flex;
            flex-direction: column;
            width: 50%;
            font-family: Arial, sans-serif;
        }

        .nk-wg7-title {
            font-weight: bold;
        }

        .amount-container {
            display: flex;
            align-items: center;
            margin: 10px 0;
        }

        .amount, .hidden-balance, .account-number {
            font-size: 24px;
            margin: 0 10px 0 0;
            display: flex;
            align-items: center;
        }

        .hidden-balance {
            display: none;
        }

        .account-number {
            font-size: 20px;
            display: flex;
            align-items: center;
        }

        .icon-button {
            cursor: pointer;
            border-radius: 1.5px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0.5px 0.5px;
            margin-left: 10px;
        }

        .icon-button:hover {
            background-color: #0056b3;
        }
        #custom-alert {
            display: none;
            position: fixed;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            opacity: 0;
            transition: opacity 0.5s;
        }

        #custom-alert.show {
            display: block;
            opacity: 1;
        }

        #custom-alert.hide {
            opacity: 0;
        }
    </style>
                <script>
                    window.addEventListener('load', function() {
            document.querySelector('.preloader').style.display = 'none';
            document.body.classList.add('loaded');
        });
                
        function toggleBalance() {
            const balance = document.getElementById('balance');
            const hiddenBalance = document.getElementById('hidden-balance');
            if (balance.style.display === 'none') {
                balance.style.display = 'block';
                hiddenBalance.style.display = 'none';
            } else {
                balance.style.display = 'none';
                hiddenBalance.style.display = 'block';
            }
        }

        function copyAccountNumber() {
            const accountNumber = document.getElementById('account-number').innerText;
            navigator.clipboard.writeText(accountNumber).then(function() {
                showAlert();
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }

        function showAlert() {
            const alertBox = document.getElementById('custom-alert');
            alertBox.classList.add('show');
            setTimeout(() => {
                alertBox.classList.remove('show');
                alertBox.classList.add('hide');
                setTimeout(() => {
                    alertBox.classList.remove('hide');
                }, 500);
            }, 2000);
        }
    </script>
</body>

</html>