<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';
?>
  
    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="../images/favicon.jpg">
    <!-- Page Title  -->
    <title>Transfer - Liberty</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<style>
   /* General body styling */
body {
    overflow: auto; /* Allow scrolling */
}

/* Styling for the preloader */
.preloader {
    position: fixed;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.preloader img {
    width: 100px; /* Adjust the size of the spinner */
}

/* Loader styling */
.loader {
    border: 4px solid #f3f3f3;
    border-top: 4px solid #3498db;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    animation: spin 2s linear infinite;
    display: none;
    margin-left: 10px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Valid and error styles */
.valid {
    color: green;
}

.error {
    color: red;
}

/* Hidden elements */
.hidden {
    display: none;
}

/* Button styles */
.btn-primary {
    background-color: #033d75;
}

.btn-secondary {
    background-color: #d13636;
}

.btn-secondary:hover {
    opacity: 0.6;
}

.btn-primary:hover {
    opacity: 0.6;
}
.keypad {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin: 20px 0;
        }

        .keypad button {
            width: 100%;
            height: 50px;
            font-size: 20px;
        }

        #pinInput {
            pointer-events: none;
            user-select: none;
        }
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
    
    <div class="preloader">
        <img src="loader.gif" alt="Loading...">
    </div>
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo">
                                    <img class="logo-dark logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                
                <!-- main header @e -->    <div class="nk-content">

    <div class="container mt-5">
        <h2 class="mb-4">Send Money</h2>
        <form id="accountForm">
            <div class="form-group">
                <label for="accountNumber">Account Number:</label>
                <input type="text" class="form-control" id="accountNumber" name="accountNumber" maxlength="10" pattern="\d{10}" required>
                <div id="loader" class="loader"></div>
                <small id="accountInfo" class="form-text"></small>
            </div>
            <button type="submit" class="btn btn-primary" id="nextButton" disabled>Next</button>
        </form>

        <div id="detailsContainer" class="hidden mt-4">
            <h3>Enter Amount and Description</h3>
            <form id="transactionForm" action="submit_transaction.php" method="post">
                <input type="hidden" name="accountNumber" id="hiddenAccountNumber">
                <div class="form-group">
                    <label for="amount">Amount:</label>
                    <input type="number" class="form-control" id="amount" name="amount" required>
                    <small id="userBalance" class="form-text text-success"></small>
                </div>
                <div class="form-group">
                    <label for="description">Description:</label>
                    <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
                </div>
                <button type="submit" class="btn btn-success">Send</button>
            </form>
        </div>

        <div id="pinContainer" class="hidden mt-4">
            <h3>Enter PIN</h3>
            <input type="password" id="pinInput" class="form-control mb-3" maxlength="4" required readonly>
            <div class="keypad">
                <button type="button" class="btn btn-secondary" onclick="appendPin('1')">1</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('2')">2</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('3')">3</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('4')">4</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('5')">5</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('6')">6</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('7')">7</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('8')">8</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('9')">9</button>
                <button type="button" class="btn btn-secondary" onclick="clearPin()">C</button>
                <button type="button" class="btn btn-secondary" onclick="appendPin('0')">0</button>
                <button type="button" class="btn btn-secondary" onclick="deletePin()">←</button>
            </div>
            <button class="btn btn-primary" id="confirmPinButton" disabled>Confirm</button>
        </div>
    </div>

    <script>
        const accountNumberInput = document.getElementById('accountNumber');
        const loader = document.getElementById('loader');
        const accountInfo = document.getElementById('accountInfo');
        const nextButton = document.getElementById('nextButton');
        const detailsContainer = document.getElementById('detailsContainer');
        const hiddenAccountNumber = document.getElementById('hiddenAccountNumber');
        const userBalance = document.getElementById('userBalance');
        const pinContainer = document.getElementById('pinContainer');
        const transactionForm = document.getElementById('transactionForm');
        const pinInput = document.getElementById('pinInput');
        const confirmPinButton = document.getElementById('confirmPinButton');

        accountNumberInput.addEventListener('input', function() {
            const accountNumber = this.value;

            if (accountNumber.length === 10) {
                loader.style.display = 'inline-block';

                fetch('validate_account.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ accountNumber: accountNumber })
                })
                .then(response => response.json())
                .then(data => {
                    loader.style.display = 'none';
                    if (data.success) {
                        accountInfo.textContent = `✔ Valid Account: ${data.full_name}`;
                        accountInfo.classList.remove('error');
                        accountInfo.classList.add('valid');
                        nextButton.disabled = false;
                    } else {
                        accountInfo.textContent = '✖ Invalid Account Number';
                        accountInfo.classList.remove('valid');
                        accountInfo.classList.add('error');
                        nextButton.disabled = true;
                    }
                })
                .catch(error => {
                    loader.style.display = 'none';
                    accountInfo.textContent = 'Error validating account';
                    accountInfo.classList.remove('valid');
                    accountInfo.classList.add('error');
                    nextButton.disabled = true;
                });
            } else {
                loader.style.display = 'none';
                accountInfo.textContent = '';
                accountInfo.classList.remove('valid', 'error');
                nextButton.disabled = true;
            }
        });

        document.getElementById('accountForm').addEventListener('submit', function(event) {
            event.preventDefault();
            hiddenAccountNumber.value = accountNumberInput.value;

            fetch('get_balance.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    userBalance.textContent = `Your balance: $${data.balance}`;
                } else {
                    userBalance.textContent = 'Error fetching balance';
                }
            })
            .catch(error => {
                userBalance.textContent = 'Error fetching balance';
            });

            detailsContainer.classList.remove('hidden');
            nextButton.style.display = 'none';
        });

        transactionForm.addEventListener('submit', function(event) {
            event.preventDefault();
            detailsContainer.style.display = 'none';
            pinContainer.classList.remove('hidden');
        });

        function appendPin(digit) {
            if (pinInput.value.length < 4) {
                pinInput.value += digit;
            }
            checkPinLength();
        }

        function deletePin() {
            pinInput.value = pinInput.value.slice(0, -1);
            checkPinLength();
        }

        function clearPin() {
            pinInput.value = '';
            checkPinLength();
        }

        function checkPinLength() {
            confirmPinButton.disabled = pinInput.value.length !== 4;
        }

        confirmPinButton.addEventListener('click', function() {
    fetch('validate_pin.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ pin: pinInput.value })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Proceed with the transaction
            transactionForm.submit();
        } else {
            if (data.error) {
                alert(data.error);
            } else {
                alert('Invalid PIN');
            }
        }
    })
    .catch(error => {
        alert('Error validating PIN: ' + error.message);
    });
});

    </script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
<?php require 'server/footer.php' ?>
</body>
</html>
