<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';
?>

<!DOCTYPE html>
<html lang="en-US" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="../images/favicon.jpg">
    <!-- Page Title  -->
    <title>Liberty Loan Center</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
    <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css">
    <link href="../css/toastr.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
        .goog-te-gadget-simple {
            border: none;
        }
        .goog-te-gadget-simple a {
            color: #000;
        }
        .btn-primary {
            background-color: #033d75;
        }
        .btn-secondary {
            background-color: #d13636;
        }
        .btn-secondary:hover { opacity: 0.6; }
        .btn-primary:hover { opacity: 0.6; }
        .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
        .loan-form {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            background: #f9f9f9;
        }
        .loan-form h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .loan-form .form-group {
            margin-bottom: 15px;
        }
        .loan-form .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .loan-form .form-group input,
        .loan-form .form-group select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .loan-form .form-group button {
            width: 100%;
            padding: 10px;
            background-color: #033d75;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .loan-form .form-group button:hover {
            background-color: #022c57;
        }
        .popup {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background: #fff;
            border: 1px solid #ddd;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            display: none;
            z-index: 10000;
        }
        .popup h2 {
            margin: 0 0 10px;
        }
        .popup p {
            margin: 0 0 20px;
        }
        .popup button {
            padding: 10px 20px;
            background-color: #033d75;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .popup button:hover {
            background-color: #022c57;
        }
        .blur {
            filter: blur(5px);
            pointer-events: none;
        }
    </style>
</head>
<body class="nk-body npc-crypto bg-white has-sidebar">
    <div class="preloader">
        <img src="loader.gif" alt="Loading...">
    </div>
    <div class="nk-app-root">
        <div class="nk-main">
            <div class="blur-container">
                <?php require 'server/sidebar.php' ?>
                <div class="nk-wrap">
                    <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                        <div class="container-fluid">
                            <div class="nk-header-wrap">
                                <div class="nk-menu-trigger d-xl-none ml-n1">
                                    <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu">
                                        <em class="icon ni ni-menu"></em>
                                    </a>
                                </div>
                                <div class="nk-header-brand d-xl-none">
                                    <a href="#" class="logo-link">
                                        <img class="logo-light logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo">
                                        <img class="logo-dark logo-img" src="../logo.jpeg" srcset="../logo.jpeg" alt="logo-dark">
                                    </a>
                                </div>
                                <div class="nk-header-news d-none d-xl-block">
                                    <div class="nk-news-list">
                                        <a class="nk-news-item" href="#">
                                            <div class="nk-news-icon">
                                                <em class="icon ni ni-card-view"></em>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <?php require 'server/dropdown1.php' ?>
                            </div>
                        </div>
                    </div>
                    <div class="loan-form">
                        <h2>Apply for a Loan</h2>
                        <form id="loanForm">
                            <div class="form-group">
                                <label for="fullName">Full Name</label>
                                <input type="text" id="fullName" name="fullName" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" id="email" name="email" required>
                            </div>
                            <div class="form-group">
                                <label for="loanAmount">Loan Amount</label>
                                <input type="number" id="loanAmount" name="loanAmount" required>
                            </div>
                            <div class="form-group">
                                <label for="loanPurpose">Loan Purpose</label>
                                <select id="loanPurpose" name="loanPurpose" required>
                                    <option value="business">Business</option>
                                    <option value="personal">Personal</option>
                                    <option value="education">Education</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <button type="submit">Submit Application</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="popup" id="loanPopup">
                <h2>Loan Application Status</h2>
                <p>Sorry, you're not qualified to take a loan at the moment. You need to bank with us for at least a year to qualify for a loan.</p>
                <button onclick="closePopup()">Back</button>
            </div>
        </div>
    </div>
    <?php require 'server/footer.php' ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            setTimeout(function() {
                document.querySelector(".blur-container").classList.add("blur");
                document.getElementById("loanPopup").style.display = 'block';
            }, 1000);
        });

        function closePopup() {
            window.history.back();
        }
    </script>
</body>
</html>
