<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Get user ID from session
$user_id = $_SESSION['user_id'];

try {
    // Fetch card details from the database using PDO
    $query = "SELECT card_number, card_cvv, card_expiry, balance, full_name FROM users WHERE id = :user_id";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Handle the case if no data is found (optional)
    if (!$user) {
        echo "<p>No card details found for this user.</p>";
        exit();
    }

    // Check if card details are null and redirect if necessary
    if (empty($user['card_number']) || empty($user['card_cvv']) || empty($user['card_expiry'])) {
        header("Location: index"); // Replace 'dashboard.php' with the correct path
        exit();
    }

    // Assign the retrieved values to variables
    $cardNumber = $user['card_number'];
    $cvv = $user['card_cvv'];
    $expiryDate = $user['card_expiry'];
    $fullName = $user['full_name'];
    $balance = $user['balance'];
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit();
}



// Query to get the settings table (default currency and symbol)
$query = "SELECT currency, symbol FROM settings LIMIT 1";
$stmt = $pdo->prepare($query);
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

// Store the values from the settings table
$defaultCurrency = $settings['currency']; // e.g., USD, EUR, etc.
$defaultSymbol = $settings['symbol']; // e.g., $, €, ₦, etc.

$query = "SELECT * FROM users WHERE id = :user_id"; // Get VAT, currency, and symbol for the logged-in user
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_SESSION['user_id']]); // Assuming user_id is stored in the session
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get user currency, symbol, and VAT status from the result
$userCurrency = $user['currency'];
$userSymbol = $user['symbol'];
$userBalance = $user['balance'];
$vatStatus = $user['vat'];

// Determine which currency and symbol to use
$currency = !empty($userCurrency) ? $userCurrency : $defaultCurrency;
$symbol = !empty($userSymbol) ? $userSymbol : $defaultSymbol;
?>
?>
    <!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="../images/favicon.jpg">
    <!-- Page Title  -->
    <title>SwiftHeart Dashboard</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
     <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
     <link href="../css/toastr.css" rel="stylesheet"/>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
   </head>
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
   <script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}
</script>
<script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
.goog-te-gadget-simple {
border:none;
}
.goog-te-gadget-simple a {
color:#000;
}
</style>
<style type="text/css">
    .btn-primary{
        background-color: #033d75;
    }
    .btn-secondary{
        background-color: #d13636;
    }
    .btn-secondary:hover{opacity: 0.6;}
    .btn-primary:hover{opacity: 0.6;}
    
    .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: auto; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
        .card {
            border-radius: 10px;
            padding: 20px;
            background: linear-gradient(135deg, #2c3e50, #3498db);
            color: #fff;
        }
        .nk-wgw-inner {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            height: 100%;
        }
        .nk-wgw-icon {
            font-size: 3em;
            margin-bottom: 10px;
        }
        .nk-wgw-title {
            font-size: 1.5em;
            margin: 0;
        }
        .nk-wgw-balance {
            margin-top: 20px;
        }
        .nk-wgw-balance .amount {
            font-size: 1.2em;
            letter-spacing: 2px;
        }
        .tranx-date {
            font-size: 0.9em;
            margin-top: 5px;
        }
        .nk-wgw-actions {
            margin-top: 20px;
            background-color: rgba(0, 0, 0, 0.1);
            padding: 10px;
            border-radius: 8px;
        }
        .nk-wgw-actions ul {
            list-style: none;
            padding: 0;
            display: flex;
            gap: 10px;
            justify-content: space-around;
        }
        .nk-wgw-actions li {
            flex: 1;
        }
        .nk-wgw-actions a {
            color: #fff;
            text-decoration: none;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #444;
            padding: 8px;
            border-radius: 4px;
            transition: background-color 0.3s;
        }
        .nk-wgw-actions a:hover {
            background-color: #666;
        }
        .nk-wgw-more {
            margin-top: 20px;
            text-align: right;
        }
        .nk-wgw-more a {
            color: #fff;
            text-decoration: none;
        }
</style>
<body class="nk-body npc-crypto bg-white has-sidebar ">
    
    
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="https://swiftheart.uk/swift/logo.png" srcset="https://swiftheart.uk/swift/logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="https://swiftheart.uk/swift/logo.png" srcset="https://swiftheart.uk/swift/logo.png" alt="logo-dark">
  
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e --> <!-- content @s -->
                <div class="nk-content nk-content-fluid">
                    <div class="container-xl wide-lg">
                        <div class="nk-content-body">
                            <div class="nk-block-head">
                                <div class="nk-block-head-sub"><span>MasterCard</span> </div>
                                <div class="nk-block-between-md g-4">
                                    <div class="nk-block-head-content">
                                        <h2 class="nk-block-title fw-normal">MasterCard Management</h2>
                                        <div class="nk-block-des">
                                            <p>A fall back option for customers who have forgotten or lost their Card, but need to perform urgent online purchase.</p>
                                        </div>
                                    </div>
                                </div><!-- .nk-block-between -->
                            </div><!-- .nk-block-head -->
                            <div class="nk-block">
                                <div class="nk-block-head-sm">
                                    <div class="nk-block-head-content">
                                        <h5 class="nk-block-title title">Available cards</h5>
                                    </div>
                                </div>
                                <div class="row g-gs">
                                	                                	 
                                    <div class="col-sm-12 col-lg-6 col-xl-6 col-xxl-6">
        
                        <style>
    .card-table {
        margin-top: 20px;
    }
    .card-preview {
        margin-top: 20px;
        display: flex;
        justify-content: center;
    }
    .card {
        width: 320px;
        height: 200px;
        border-radius: 10px;
        background: linear-gradient(to bottom right, #4a90e2, #0033a0);
        color: #fff;
        padding: 20px;
        position: relative;
        font-family: 'Arial', sans-serif;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }
    .card-logo-top {
        position: absolute;
        top: 15px;
        right: 15px;
        width: 60px;
    }
    .card-logo-bottom {
        position: absolute;
        bottom: 15px;
        right: 15px;
        width: 80px;
        opacity: 0.8;
    }
    .card-brand {
        font-size: 1.5em;
        color: #f1c40f;
        font-weight: bold;
    }
    .card-number {
        font-size: 1.6em;
        letter-spacing: 2px;
        margin-top: 50px;
    }
    .card-expiry,
    .card-cvv {
        font-size: 0.9em;
    }
    .card-expiry {
        text-align: left;
    }
    .card-cvv {
        text-align: left;
    }
    .card-name {
        font-size: 0.9em;
    }
</style>

<div class="card-preview">
    <div class="card">
        <img src="https://swiftheart.uk/swift/logo.png" alt="MasterCard Logo" class="card-logo-top">
        <div class="card-number"><?php echo htmlspecialchars($cardNumber); ?></div>
        <div class="card-cvv">CVV: <?php echo htmlspecialchars($cvv); ?></div>
        <div class="card-expiry">Expires: <?php echo htmlspecialchars($expiryDate); ?></div>
        <div class="card-name"><?php echo htmlspecialchars($fullName); ?></div>
        <img src="../superadmin/card.png" alt="MasterCard" class="card-logo-bottom">
    </div>
</div>
    </div><!-- .col -->
  <!--- Add Fund to Card------->
 <div class="modal fade" tabindex="-1" id="addFund10" >
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
            <div class="modal-content">
                <div class="modal-body modal-body-lg">
                    <div class="nk-block-head nk-block-head-xs text-center">
                    	<em class="icon ni ni-master-card h1 text-primary"></em>                        <h5 class="nk-block-title">Fund Visual Card*</h5>
                        <div class="nk-block-text">
                    </div>
                    <div class="nk-block">
                        <div class="buysell-field form-group">
                            <div class="form-label-group">
                                <label class="form-label">Choose payment account</label>
                            </div>
                               <input type="hidden" value="btc" name="bs-currency" id="buysell-choose-currency-modal">
                            <div class="dropdown buysell-cc-dropdown">
                                <a href="#" class="buysell-cc-choosen dropdown-indicator" data-toggle="dropdown">
                                    <div class="coin-item coin-btc">
                                        <div class="coin-icon">
                                            <em class="icon ni ni-wallet-out"></em>
                                        </div>
                                        <div class="coin-info">
                                            <span class="coin-name">Crypto Currency Account</span>
                                            <span class="coin-text">Balance(USD161465084.5)</span>
                                        </div>
                                    </div>
                                </a>
                            <div class="dropdown-menu dropdown-menu-auto dropdown-menu-mxh">
                                    <ul class="buysell-cc-list">
                                        <li class="buysell-cc-item selected">
                                            <a href="#" class="buysell-cc-opt" data-currency="btc">
                                                <div class="coin-item coin-btc">
                                                    <div class="coin-icon">
                                                        <em class="icon ni ni-wallet-out"></em>
                                                    </div>
                                                    <div class="coin-info">
                                                        <span class="coin-name">Crypto Currency Account</span>
                                                        <span class="coin-text">7836*****</span>
                                                    </div>
                                                </div>
                                            </a>
                                        </li> <!-- .buysell-cc-item -->
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <form action="" method="post">
                         <div class="buysell-field form-group">
                            <div class="form-label-group">
                              <label class="form-label" for="buysell-amount">Amount</label>
                                </div>
                                  <div class="form-control-group">
                                    <input type="number" step="any" class="form-control form-control form-control-number" max="150000" name="amount10" id="amount10" placeholder="200.00" required>
                                          <div class="form-dropdown">
                                               <div class="text">USD</div>  
                                           </div>
                                       </div>
                                            <div class="form-note-group">
                                                <span class="buysell-rate form-note-alt">Maximum Daily Limit:150,000 USD</span>
                                            </div>
                                        </div><!-- .buysell-field -->
   
                          <div class="form-group">
                             <div class="form-label-group">
                                <label class="form-label">What is your pet name? <span class="text-danger">*</span></label>
                              </div>
                              <div class="form-control-group">
                                <input type="password" name="answer10" id="answer10" placeholder="Enter answer"  required class="form-control form-control-lg">
                            </div>
                         </div>
                         <div class="addFundResult10"></div>
                         <hr>
                         <div class="form-control-group">
                        	 <button class="btn btn-primary addFundBtn10 btn-block"id="btn10" type="submit">Add Fund</button>
                            <div class="pt-3">
                                <a href="#" data-dismiss="modal" class="btn btn-sm btn-danger">Cancel</a>
                            </div>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
          </div>
         </div>
             <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>    
    <script type="text/javascript">
     $(document).ready(function () {
    $('.addFundBtn10').click(function (e) {
      e.preventDefault();
      document.getElementById("btn10").disabled = true;	
      var amount10 = $('#amount10').val();
      var answer10 = $('#answer10').val();
       $.ajax
        ({
          type: "POST",
          url: "../scripts/auth?action=addFund&cardid=10",
          data: {"amount10": amount10, "answer10": answer10, },
          success: function (data) {
          	document.getElementById("btn10").disabled = false;
            $('.addFundResult10').html(data);
          }
        });
    });
  });
    </script>
                                                                	 
                                    
                                                                </div><!-- .row -->
                            </div>
                        </div>
                    </div>
                </div>

	<?php require 'server/footer.php' ?>
</body>

</html>