<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';

// Assuming session contains user_id
$user_id = $_SESSION['user_id'];

// Prepare and execute the query to fetch user data using PDO
$stmt = $pdo->prepare("SELECT full_name, account_number, balance, address, email, phone FROM users WHERE id = :user_id");
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
$stmt->execute();

// Fetch the user data
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("User not found.");
}
?>

<!DOCTYPE html>
<html lang="en-US" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="../images/favicon.jpg">
    <!-- Page Title  -->
    <title>Account Setting</title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="../scss/sweetalert.css">
    <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
    <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css"> 
    <link href="../css/toastr.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    <style>
        .goog-te-gadget-simple {
            border: none;
        }
        .goog-te-gadget-simple a {
            color: #000;
        }
        .btn-primary {
            background-color: #033d75;
        }
        .btn-secondary {
            background-color: #d13636;
        }
        .btn-secondary:hover { opacity: 0.6; }
        .btn-primary:hover { opacity: 0.6; }
        
        .preloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .preloader img {
            width: 100px; /* Adjust the size of the spinner */
        }
        body {
            overflow: hidden; /* Prevent scrolling while loading */
        }
        body.loaded {
            overflow: auto;
        }
    </style>
</head>
<body class="nk-body npc-crypto bg-white has-sidebar">
    
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main">
            <?php require 'server/sidebar.php' ?>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap">
                <!-- main header @s -->
                <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon fas fa-bars"></em></a>
                            </div>
                            
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <div class="nk-news-icon">
                                            <em class="icon fas fa-bars"></em>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <?php require 'server/dropdown1.php' ?>
                        </div>
                    </div>
                </div>
                <!-- main header @e -->

                <!-- content @s -->
<div class="nk-content">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="profile-wrapper">
                    <div class="company-logo">
                        <img src="https://swiftheart.uk/swift/logo.png" alt="Company Logo">
                    </div>
                    <h2>User Account Information</h2>
                    <div class="profile-info">
                        <div class="profile-item">
                            <span class="label"><strong>Full Name:</strong></span>
                            <span class="value"><?php echo htmlspecialchars($user['full_name']); ?></span>
                        </div>
                        <div class="profile-item">
                            <span class="label"><strong>Account Number:</strong></span>
                            <span class="value"><?php echo htmlspecialchars($user['account_number']); ?></span>
                        </div>
                        <div class="profile-item">
                            <span class="label"><strong>Balance:</strong></span>
                            <span class="value"><?php echo htmlspecialchars($user['balance']); ?></span>
                        </div>
                        <div class="profile-item">
                            <span class="label"><strong>Address:</strong></span>
                            <span class="value"><?php echo htmlspecialchars($user['address']); ?></span>
                        </div>
                        <div class="profile-item">
                            <span class="label"><strong>Email:</strong></span>
                            <span class="value"><?php echo htmlspecialchars($user['email']); ?></span>
                        </div>
                        <div class="profile-item">
                            <span class="label"><strong>Phone:</strong></span>
                            <span class="value"><?php echo htmlspecialchars($user['phone']); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

<style>
    .profile-wrapper {
        background-color: #f5f7fa;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    .company-logo {
        text-align: center;
        margin-bottom: 20px;
    }
    .company-logo img {
        max-width: 150px;
        border-radius: 50%;
    }
    h2 {
        text-align: center;
        margin-bottom: 30px;
        color: #033d75;
    }
    .profile-info {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }
    .profile-item {
        display: flex;
        justify-content: space-between;
        padding: 10px;
        background: #ffffff;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    .label {
        color: #555;
    }
    .value {
        font-weight: bold;
        color: #000;
    }
</style>


                <?php require 'server/footer.php' ?>
            </div>
            <!-- wrap @e -->
        </div>
        <!-- main @e -->
    </div>

</body>
</html>
