<?php
session_start();
require 'config.db.php'; // Ensure this file connects to your database

// Assume that the user is logged in and we have their user_id stored in the session
$user_id = $_SESSION['user_id'];

// Calculate the date 10 days ago
$ten_days_ago = date('Y-m-d H:i:s', strtotime('-10 days'));

// Fetch messages from the last 10 days
$stmt = $pdo->prepare('SELECT * FROM messages WHERE user_id = ? AND created_at >= ? ORDER BY created_at ASC');
$stmt->execute([$user_id, $ten_days_ago]);
$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Return the messages as JSON
echo json_encode($messages);
?>
