<?php

// Retrieve user information from the database
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];

    $query = "SELECT full_name, balance, account_number, frozen FROM users WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $user_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $user = mysqli_fetch_assoc($result);

    if (!$user) {
        // If user not found, log out
        session_unset();
        session_destroy();
        header('Location: https://west-libertygroup.com');
        exit();
    }
}

// Get the current hour
$currentHour = date('H');

// Determine the greeting based on the time of day
if ($currentHour >= 5 && $currentHour < 12) {
    $greeting = 'Good Morning';
} elseif ($currentHour >= 12 && $currentHour < 17) {
    $greeting = 'Good Afternoon';
} elseif ($currentHour >= 17 && $currentHour < 21) {
    $greeting = 'Good Evening';
} else {
    $greeting = 'Good Night';
}

// Fetch transactions where user is either sender or receiver
$query = "SELECT * FROM transactions WHERE sender_id = ? OR receiver_id = ? ORDER BY created_at DESC LIMIT 30";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "ii", $user_id, $user_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$transactions = mysqli_fetch_all($result, MYSQLI_ASSOC);
?>
