<?php

// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);



// Set the inactivity timeout duration (in seconds)
$timeout_duration = 20 * 60; // 20 minutes

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: https://west-libertygroup.com/securepass/index');
    exit();
}
 
// Check if the last activity time is set
if (isset($_SESSION['last_activity'])) {
    // Calculate the time elapsed since the last activity
    $elapsed_time = time() - $_SESSION['last_activity'];

    // If the elapsed time exceeds the timeout duration, log the user out
    if ($elapsed_time >= $timeout_duration) {
        session_unset();
        session_destroy();
        header('Location: https://west-libertygroup.com/securepass/index');
        exit();
    }
}

// Update the last activity time
$_SESSION['last_activity'] = time();
?>
