<?php
session_start();
require 'config.db.php'; // Ensure this file connects to your database

$response = [];

try {
    if (isset($_POST['chat_message']) && !empty(trim($_POST['chat_message']))) { 
        $user_id = $_SESSION['user_id']; // Get the user's ID from the session
        $message = trim($_POST['chat_message']); // Updated to match the new name attribute

        // Retrieve the user's full name from the users table
        $stmt = $pdo->prepare('SELECT full_name FROM users WHERE id = ?');
        $stmt->execute([$user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            $sender_name = $user['full_name'];
        } else {
            throw new Exception('User not found.');
        }

        // Prepare the SQL query with placeholders
        $stmt = $pdo->prepare('INSERT INTO messages (user_id, sender, sender_name, content, created_at) VALUES (?, ?, ?, ?, NOW())');

        // Execute the query with the actual data
        $stmt->execute([$user_id, 'user', $sender_name, $message]);

        if ($stmt->rowCount() > 0) {
            $response['success'] = true;
        } else {
            $response['success'] = false;
            $response['error'] = 'Failed to insert the message.';
        }
    } else {
        $response['success'] = false;
        $response['error'] = 'Message cannot be empty.';
    }
} catch (Exception $e) {
    $response['success'] = false;
    $response['error'] = 'Error: ' . $e->getMessage();
}

// Return the response as JSON
echo json_encode($response);
?>
