<div class="nk-block nk-block-lg">
    <div class="row gy-gs">
        <div class="col-md-6">
            <div class="card-head">
                <div class="card-title mb-0">
                    <h5 class="title">Recent Transaction Activities</h5>
                </div>
                <div class="card-tools">
                    <ul class="card-tools-nav">
                        <li class="active"><a href="#">All</a></li>
                    </ul>
                </div>
            </div>
            <div class="tranx-list card card-bordered">
                <?php foreach ($transactions as $transaction): ?>
                    <?php if ($transaction['sender_id'] == $user_id && $transaction['transaction_type'] == 'debit'): ?>
                        <div class="tranx-item">
                            <div class="tranx-col">
                                <div class="tranx-info">
                                    <div class="tranx-data">
                                        <div class="tranx-label"><?php echo htmlspecialchars($transaction['description']); ?><em class="tranx-icon sm icon fas fa-arrow-up"></em></div>
                                        <div class="tranx-date"><?php echo date('d M Y, h:i a', strtotime($transaction['created_at'])); ?></div>
                                        <div class="text-primary">ONLINE TRANSFER/<?php echo strtoupper(substr(md5($transaction['id']), 0, 4)); ?>/0850</div>
                                    </div>
                                </div>
                            </div>
                            <div class="tranx-col">
                                <div class="tranx-amount">
                                    <div class="tranx-date">Amount</div>
                                    <div class="text-danger fs-16px">
                                        - <?php echo htmlspecialchars($transaction['amount']); ?>
                                        <span class="currency currency-usd"><?php echo $currency; ?></span>
                                    </div>
                                    <div class="number-sm"><strong class="text-success">Successful</strong></div>
                                </div>
                            </div>
                            <div class="tranx-col">
                                <div class="tranx-amount">
                                    <div class="number">Debit</div>
                                    <span class="badge badge-dim badge-pill badge-outline-primary" data-toggle="modal" data-target="#modalDefault<?php echo $transaction['id']; ?>">Details</span>
                                </div>
                            </div>
                        </div>
                    <?php elseif ($transaction['receiver_id'] == $user_id && $transaction['transaction_type'] == 'credit'): ?>
                        <div class="tranx-item">
                            <div class="tranx-col">
                                <div class="tranx-info">
                                    <div class="tranx-data">
                                        <div class="tranx-label"><?php echo htmlspecialchars($transaction['description']); ?><em class="tranx-icon sm icon fas fa-arrow-down"></em></div>
                                        <div class="tranx-date"><?php echo date('d M Y, h:i a', strtotime($transaction['created_at'])); ?></div>
                                        <div class="text-primary">ONLINE TRANSFER/<?php echo strtoupper(substr(md5($transaction['id']), 0, 4)); ?>/0850</div>
                                    </div>
                                </div>
                            </div>
                            <div class="tranx-col">
                                <div class="tranx-amount">
                                    <div class="tranx-date">Amount</div>
                                    <div class="text-success fs-16px">
                                        + <?php echo htmlspecialchars($transaction['amount']); ?>
                                        <span class="currency currency-usd"><?php echo $currency; ?></span>
                                    </div>
                                    <div class="number-sm"><strong class="text-success">Credited</strong></div>
                                </div>
                            </div>
                            <div class="tranx-col">
                                <div class="tranx-amount">
                                    <div class="number">Credit</div>
                                    <span class="badge badge-dim badge-pill badge-outline-primary" data-toggle="modal" data-target="#modalDefault<?php echo $transaction['id']; ?>">Details</span>
                                </div>
                            </div>
                        </div>
                    <?php elseif ($transaction['receiver_id'] == $user_id && $transaction['transaction_type'] == 'account fund'): ?>
                        <div class="tranx-item">
                            <div class="tranx-col">
                                <div class="tranx-info">
                                    <div class="tranx-data">
                                        <div class="tranx-label"><?php echo htmlspecialchars($transaction['description']); ?><em class="tranx-icon sm icon fas fa-money-bill"></em></div>
                                        <div class="tranx-date"><?php echo date('d M Y, h:i a', strtotime($transaction['created_at'])); ?></div>
                                        <div class="text-primary">Account Funding/<?php echo strtoupper(substr(md5($transaction['id']), 0, 4)); ?>/0850</div>
                                    </div>
                                </div>
                            </div>
                            <div class="tranx-col">
                                <div class="tranx-amount">
                                    <div class="tranx-date">Amount</div>
                                    <div class="text-success fs-16px">
                                        + <?php echo htmlspecialchars($transaction['amount']); ?>
                                        <span class="currency currency-usd"><?php echo $currency; ?></span>
                                    </div>
                                    <div class="number-sm"><strong class="text-success">Completed</strong></div>
                                </div>
                            </div>
                            <div class="tranx-col">
                                <div class="tranx-amount">
                                    <div class="number">Funding</div>
                                    <span class="badge badge-dim badge-pill badge-outline-primary" data-toggle="modal" data-target="#modalDefault<?php echo $transaction['id']; ?>">Details</span>
                                </div>
                            </div>
                        </div>

                    <?php elseif ($transaction['receiver_id'] == $user_id && $transaction['transaction_type'] == 'withdraw'): ?>
    <div class="tranx-item">
        <div class="tranx-col">
            <div class="tranx-info">
                <div class="tranx-data">
                    <div class="tranx-label"><?php echo htmlspecialchars($transaction['description']); ?><em class="tranx-icon sm icon fas fa-money-bill"></em></div>
                    <div class="tranx-date"><?php echo date('d M Y, h:i a', strtotime($transaction['created_at'])); ?></div>
                    <div class="text-primary">Withdrawal/<?php echo strtoupper(substr(md5($transaction['id']), 0, 4)); ?>/0850</div>
                </div>
            </div>
        </div>
        <div class="tranx-col">
            <div class="tranx-amount">
                <div class="tranx-date">Amount</div>
                <div class="<?php echo ($service_fee == 1) ? 'text-success' : 'text-danger'; ?> fs-16px">
                    - <?php echo htmlspecialchars($transaction['amount']); ?>
                    <span class="currency currency-usd"><?php echo $currency; ?></span>
                </div>
                <div class="number-sm">
                    <strong class="<?php echo ($service_fee == 1) ? 'text-success' : 'text-danger'; ?>">
                        <?php echo ($service_fee == 1) ? 'Successful' : 'Pending'; ?>
                    </strong>
                </div>
            </div>
        </div>
        <div class="tranx-col">
            <div class="tranx-amount">
                <div class="number">Withdrawal</div>
                <span class="badge badge-dim badge-pill badge-outline-primary" data-toggle="modal" data-target="#modalDefault<?php echo $transaction['id']; ?>">Details</span>
            </div>
        </div>
    </div>
<?php endif; ?>

                                                           <!-- Modal -->
<div class="modal fade" id="modalDefault<?php echo $transaction['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="transactionModal<?php echo $transaction['id']; ?>" aria-hidden="true" style="z-index: 1050;">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Transaction Receipt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Bank Receipt Design -->
                <div class="text-center mb-3">
                    <h3 class="text-uppercase font-weight-bold">BLX Growth</h3>
                    <p><em>5th Floor, Fruit & Wool Exchange, Duval Square, London E1 6PW, United Kingdom</em></p>
                    <p><strong>Email:</strong> info@swiftheart.uk</p>
                    <hr>
                </div>
                <div class="receipt-content">
                    <table class="table table-bordered">
                        <tbody>
                            <tr>
                                <th>Transaction ID</th>
                                <td><?php echo strtoupper(substr(md5($transaction['id']), 0, 16)); ?></td>
                            </tr>
                            <tr>
                                <th>Transaction Type</th>
                                <td><?php echo ucfirst($transaction['transaction_type']); ?></td>
                            </tr>
                            <tr>
                                <th>Amount</th>
                                <td><?php echo htmlspecialchars($transaction['amount']); ?> <span class="currency currency-usd"><?php echo $currency; ?></span></td>
                            </tr>
                            <tr>
                                <th>Description</th>
                                <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                            </tr>
                            <tr>
                                <th>Date</th>
                                <td><?php echo date('d M Y, h:i a', strtotime($transaction['created_at'])); ?></td>
                            </tr>
                            <tr>
    <th>Status</th>
    <td>
        <?php if ($user['service_fee'] == 1): ?>
            <span class="badge badge-success">Successful</span>
        <?php elseif ($transaction['status'] == '0'): ?>
            <span class="badge badge-warning">Pending</span>
        <?php else: ?>
            <span class="badge badge-success">Successful</span>
        <?php endif; ?>
    </td>
</tr>

                            <?php if ($user['service_fee'] == 1): ?>
                                        <tr>
                                            <th>Service Fee</th>
                                            <td><span class="badge badge-danger">Escrow Service Fee Applied</span></td>
                                        </tr>
                                    <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php if ($transaction['status'] == '0'): ?>
                    <div class="alert alert-warning mt-3 text-center">
                        Kindly contact the support team to clear your withdrawal charges. <br>
                        Once the withdrawal charges have been cleared, payment will be sent directly to your account.
                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="window.print();">Print Receipt</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

                               
                                                        <?php endforeach; ?>
                                                     
                                                                                                                           
                                                            </div>
                                                        </div>
                                                    </div>
    
    <input type="hidden" id="debit1" value="75.61">
                                           <input type="hidden" id="credit1" value="24.39">
                                        </div><!-- .tranx-list -->
                                    </div><!-- .col -->
                                    
                                    </div><!-- .row -->
                            </div><!-- .nk-block -->