<?php
// Enable full error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'config.db.php';

// Retrieve user_id from session
$user_id = $_SESSION['user_id'];

// Check if user is logged in
if (!$user_id) {
    echo json_encode(['status' => 'error', 'message' => 'User not logged in.']);
    exit;
}

// Retrieve the PIN from the request
$input_pin = $_POST['pin'] ?? '';

// Check the user's card status and PIN
$query = $pdo->prepare('SELECT card, pin FROM users WHERE id = :user_id');
$query->execute(['user_id' => $user_id]);
$user = $query->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo json_encode(['status' => 'error', 'message' => 'User not found.']);
} 
// elseif ($user['card'] == 0) {
//     echo json_encode(['status' => 'error', 'message' => 'Card Not Found']);
// }
elseif ($user['pin'] !== $input_pin) {
    echo json_encode(['status' => 'error', 'message' => 'Incorrect PIN']);
} else {
    echo json_encode(['status' => 'success', 'message' => 'PIN accepted']);
}

?>
